/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mail.service;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.mail.Address;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.nuxeo.ecm.platform.ec.notification.email.EmailHelper;
import org.nuxeo.ecm.platform.mail.action.MailBoxActions;
import org.nuxeo.ecm.platform.mail.action.MailBoxActionsImpl;
import org.nuxeo.ecm.platform.mail.action.MessageActionPipe;
import org.nuxeo.ecm.platform.mail.action.MessageActionPipeDescriptor;
import org.nuxeo.ecm.platform.mail.fetcher.PropertiesFetcher;
import org.nuxeo.ecm.platform.mail.fetcher.PropertiesFetcherDescriptor;
import org.nuxeo.ecm.platform.mail.service.MailService;
import org.nuxeo.ecm.platform.mail.service.SessionFactoryDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class MailServiceImpl
extends DefaultComponent
implements MailService {
    private static final String SESSION_FACTORY = "sessionFactory";
    private static final String PROPERTIES_FETCHER = "propertiesFetcher";
    private static final String ACTION_PIPES = "actionPipes";
    private final Map<String, Class<? extends PropertiesFetcher>> fetchers = new HashMap<String, Class<? extends PropertiesFetcher>>();
    private final Map<String, SessionFactoryDescriptor> sessionFactories = new HashMap<String, SessionFactoryDescriptor>();
    private final Map<String, PropertiesFetcher> configuredFetchers = new HashMap<String, PropertiesFetcher>();
    private final Map<String, MessageActionPipe> actionPipesRegistry = new HashMap<String, MessageActionPipe>();
    private final Map<String, MessageActionPipeDescriptor> actionPipeDescriptorsRegistry = new HashMap<String, MessageActionPipeDescriptor>();
    protected final Map<String, Session> sessions = new ConcurrentHashMap<String, Session>();

    public void stop(ComponentContext context) throws InterruptedException {
        this.sessions.clear();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(SESSION_FACTORY)) {
            SessionFactoryDescriptor descriptor = (SessionFactoryDescriptor)contribution;
            this.registerSessionFactory(descriptor);
        } else if (extensionPoint.equals(PROPERTIES_FETCHER)) {
            PropertiesFetcherDescriptor descriptor = (PropertiesFetcherDescriptor)contribution;
            this.fetchers.put(descriptor.getName(), descriptor.getFetcher());
        } else if (extensionPoint.equals(ACTION_PIPES)) {
            MessageActionPipeDescriptor descriptor = (MessageActionPipeDescriptor)contribution;
            this.registerActionPipe(descriptor);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(ACTION_PIPES)) {
            MessageActionPipeDescriptor descriptor = (MessageActionPipeDescriptor)contribution;
            this.actionPipesRegistry.remove(descriptor.getName());
        }
    }

    private void registerSessionFactory(SessionFactoryDescriptor descriptor) {
        this.sessionFactories.put(descriptor.getName(), descriptor);
    }

    private void registerActionPipe(MessageActionPipeDescriptor descriptor) {
        MessageActionPipeDescriptor existingDescriptor;
        if (!descriptor.getOverride() && (existingDescriptor = this.actionPipeDescriptorsRegistry.get(descriptor.getName())) != null) {
            descriptor.merge(existingDescriptor);
        }
        this.actionPipeDescriptorsRegistry.put(descriptor.getName(), descriptor);
        this.actionPipesRegistry.put(descriptor.getName(), descriptor.getPipe());
    }

    private static void setDecodeUTFFileNamesSystemProperty() {
        String toDecodeTheFilenames = Framework.getRuntime().getProperty("mail.mime.decodefilename");
        if (toDecodeTheFilenames == null) {
            return;
        }
        if ((toDecodeTheFilenames = toDecodeTheFilenames.trim().toLowerCase()).equals("true") || toDecodeTheFilenames.equals("yes")) {
            System.setProperty("mail.mime.decodefilename", "true");
            return;
        }
        System.setProperty("mail.mime.decodefilename", "false");
    }

    @Override
    public Store getConnectedStore(String name) throws MessagingException {
        return this.getConnectedStore(name, null);
    }

    @Override
    public Store getConnectedStore(String name, Map<String, Object> context) throws MessagingException {
        Properties props = this.getProperties(name, context);
        Session session = this.newSession(props);
        Store store = session.getStore();
        store.connect(props.getProperty("user"), props.getProperty("password"));
        return store;
    }

    private Properties getProperties(String name, Map<String, Object> map) {
        return this.getFetcher(name).getProperties(map);
    }

    @Override
    public Transport getConnectedTransport(String name) throws MessagingException {
        return this.getConnectedTransport(name, null);
    }

    @Override
    public Transport getConnectedTransport(String name, Map<String, Object> context) throws MessagingException {
        Properties props = this.getProperties(name, context);
        Session session = this.newSession(props);
        Transport transport = session.getTransport();
        transport.connect(props.getProperty("user"), props.getProperty("password"));
        return transport;
    }

    @Override
    public Session getSession(String name) {
        return this.getSession(name, null);
    }

    @Override
    public Session getSession(String name, Map<String, Object> context) {
        Properties props = this.getProperties(name, context);
        return this.newSession(props);
    }

    @Override
    public MailBoxActions getMailBoxActions(String factoryName, String folderName) throws MessagingException {
        return this.getMailBoxActions(factoryName, folderName, null);
    }

    @Override
    public MailBoxActions getMailBoxActions(String factoryName, String folderName, Map<String, Object> context) throws MessagingException {
        Store store = this.getConnectedStore(factoryName, context);
        Folder folder = store.getFolder(folderName);
        return new MailBoxActionsImpl(folder, true);
    }

    @Override
    public void sendMail(String text, String subject, String factory, Address[] recipients) {
        this.sendMail(text, subject, factory, recipients, null);
    }

    @Override
    public void sendMail(String text, String subject, String factory, Address[] recipients, Map<String, Object> context) {
        Session session = this.getSession(factory, context);
        MimeMessage message = new MimeMessage(session);
        try {
            message.setFrom();
            message.setSubject(subject);
            message.setRecipients(Message.RecipientType.TO, recipients);
            message.setText(text);
            Transport.send((Message)message);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PropertiesFetcher getFetcher(String name) {
        PropertiesFetcher fetcher = this.configuredFetchers.get(name);
        if (fetcher == null) {
            String fetcherName = this.sessionFactories.get(name).getFetcherName();
            Class<? extends PropertiesFetcher> clazz = this.fetchers.get(fetcherName);
            SessionFactoryDescriptor descriptor = this.sessionFactories.get(name);
            try {
                fetcher = clazz.newInstance();
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            fetcher.configureFetcher(descriptor.getProperties());
            this.configuredFetchers.put(name, fetcher);
        }
        return fetcher;
    }

    @Override
    public MessageActionPipe getPipe(String name) {
        return this.actionPipesRegistry.get(name);
    }

    protected Session newSession(Properties props) {
        String sessionKey = props.entrySet().stream().map(e -> e.getKey() + "#" + e.getValue()).sorted().collect(Collectors.joining("-", "{", "}"));
        return this.sessions.computeIfAbsent(sessionKey, k -> EmailHelper.newSession((Properties)props));
    }

    static {
        MailServiceImpl.setDecodeUTFFileNamesSystemProperty();
    }
}

