/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.indd.rendition.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.ecm.platform.pdf.PDFMerge;
import org.nuxeo.labs.indd.rendition.service.InDesignRenditionService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class InDesignRenditionServiceImpl
extends DefaultComponent
implements InDesignRenditionService {
    public static final String COMMAND_NAME = "inddpagepreview";
    public static final String INPUT_FILE_PATH_PARAMETER = "inputFilePath";

    public void activate(ComponentContext context) {
        super.activate(context);
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
    }

    public void applicationStarted(ComponentContext context) {
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
    }

    @Override
    public List<Blob> getPagesAsImages(Blob blob) {
        CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
        try {
            CloseableFile closeable = blob.getCloseableFile("." + FilenameUtils.getExtension((String)blob.getFilename()));
            CmdParameters params = cles.getDefaultCmdParameters();
            params.addNamedParameter(INPUT_FILE_PATH_PARAMETER, closeable.getFile());
            ExecResult result = ((CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class)).execCommand(COMMAND_NAME, params);
            if (!result.isSuccessful()) {
                throw result.getError();
            }
            StringBuilder sb = new StringBuilder();
            for (String line : result.getOutput()) {
                sb.append(line);
            }
            String jsonOutput = sb.toString();
            ObjectMapper jacksonMapper = new ObjectMapper();
            List resultList = (List)jacksonMapper.readValue(jsonOutput, (TypeReference)new TypeReference<List<HashMap<String, Object>>>(){});
            Map resultMap = (Map)resultList.get(0);
            Object pageImage = resultMap.get("XMP:PageImage");
            List pagesbase64 = new ArrayList<String>();
            if (pageImage == null) {
                return new ArrayList<Blob>();
            }
            if (pageImage instanceof String) {
                pagesbase64.add((String)pageImage);
            } else if (pageImage instanceof List) {
                pagesbase64 = (List)pageImage;
            }
            ArrayList<Blob> pagesJpeg = new ArrayList<Blob>();
            for (String pageBase64 : pagesbase64) {
                if (pageBase64 != null && pageBase64.startsWith("base64:")) {
                    pageBase64 = pageBase64.substring(7);
                }
                byte[] pageByte = Base64.getDecoder().decode(pageBase64);
                File tmp = Framework.createTempFile((String)"nxindd", null);
                FileUtils.writeByteArrayToFile((File)tmp, (byte[])pageByte);
                pagesJpeg.add((Blob)new FileBlob(tmp, "image/jpeg"));
            }
            return pagesJpeg;
        }
        catch (Exception e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public Blob generatePdf(Blob blob) {
        List<Blob> jpegs = this.getPagesAsImages(blob);
        ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
        ArrayList<Blob> pdfPage = new ArrayList<Blob>();
        for (Blob jpeg : jpegs) {
            BlobHolder result = conversionService.convert("image2pdf", (BlobHolder)new SimpleBlobHolder(jpeg), new HashMap());
            pdfPage.add(result.getBlob());
        }
        PDFMerge merger = new PDFMerge(new BlobList(pdfPage));
        try {
            return merger.merge("preview.pdf");
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }
}

