/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.indd.rendition.thumbnail;

import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.thumbnail.factories.ThumbnailDocumentFactory;
import org.nuxeo.labs.indd.rendition.service.InDesignRenditionService;
import org.nuxeo.runtime.api.Framework;

public class InddThumbnailFactory
extends ThumbnailDocumentFactory {
    public Blob computeThumbnail(DocumentModel doc, CoreSession session) {
        Blob blob = (Blob)doc.getPropertyValue("file:content");
        if (blob == null || !"application/x-indesign".equals(blob.getMimeType())) {
            return super.computeThumbnail(doc, session);
        }
        InDesignRenditionService inDesignRenditionService = (InDesignRenditionService)Framework.getService(InDesignRenditionService.class);
        List<Blob> pages = inDesignRenditionService.getPagesAsImages(blob);
        return pages.size() > 0 ? pages.get(0) : null;
    }
}

