/*
 * Decompiled with CFR 0.152.
 */
package com.nuxeo.intranet.jenkins.web;

import com.nuxeo.intranet.jenkins.web.JenkinsJobsFetcher;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JenkinsJsonConverter {
    private static final Log log = LogFactory.getLog(JenkinsJsonConverter.class);

    public static List<Map<String, Serializable>> convertJobs(JSONObject jsonObject, JenkinsJobsFetcher fetcher) throws IOException {
        JSONArray jsonJobs;
        ArrayList<Map<String, Serializable>> res = new ArrayList<Map<String, Serializable>>();
        if (jsonObject != null && (jsonJobs = jsonObject.optJSONArray("jobs")) != null) {
            for (Object jsonJob : jsonJobs) {
                JSONObject jsonBuild;
                String color = ((JSONObject)jsonJob).getString("color");
                if (color == null || color.startsWith("blue") || color.startsWith("grey") || color.startsWith("disabled")) continue;
                HashMap<String, Object> job = new HashMap<String, Object>();
                String url = ((JSONObject)jsonJob).getString("url");
                String jobId = ((JSONObject)jsonJob).getString("name");
                job.put("job_id", jobId);
                job.put("job_url", url);
                List<Map<String, Serializable>> subJobs = null;
                if (fetcher != null && url != null && (jsonBuild = fetcher.retrieveJSONObject(url.trim() + "lastCompletedBuild/api/json")) != null) {
                    job.putAll(JenkinsJsonConverter.convertBuild(jsonBuild));
                    subJobs = JenkinsJsonConverter.convertMultiOSDBJobs(jobId, jsonBuild, fetcher);
                }
                if (subJobs != null && !subJobs.isEmpty()) {
                    res.addAll((Collection<Map<String, Serializable>>)subJobs);
                    continue;
                }
                res.add(job);
            }
        }
        return res;
    }

    public static List<Map<String, Serializable>> convertMultiOSDBJobs(String parentBuildId, JSONObject jsonParentBuild, JenkinsJobsFetcher fetcher) throws IOException {
        JSONArray runs;
        ArrayList<Map<String, Serializable>> res = new ArrayList<Map<String, Serializable>>();
        if (jsonParentBuild.containsKey((Object)"runs") && (runs = jsonParentBuild.optJSONArray("runs")) != null) {
            for (Object jsonRun : runs) {
                String runUrl;
                if (jsonRun == null || !((JSONObject)jsonRun).has("url") || (runUrl = ((JSONObject)jsonRun).getString("url")) == null) continue;
                HashMap<String, Object> runJob = new HashMap<String, Object>();
                if (runUrl.contains("./")) {
                    String failureType;
                    JSONObject jsonRunBuild;
                    String runJobId = runUrl.substring(runUrl.indexOf("./") + 2);
                    runJobId = runJobId.substring(0, runJobId.indexOf("/"));
                    runJob.put("job_id", parentBuildId + "#" + runJobId);
                    String subUrl = runUrl;
                    if (subUrl.endsWith("/")) {
                        subUrl = subUrl.substring(0, subUrl.length() - 1);
                    }
                    subUrl = subUrl.substring(0, subUrl.lastIndexOf("/") + 1);
                    runJob.put("job_url", subUrl);
                    if (fetcher != null && (jsonRunBuild = fetcher.retrieveJSONObject(runUrl + "api/json")) != null) {
                        runJob.putAll(JenkinsJsonConverter.convertBuild(jsonRunBuild));
                    }
                    if ("SUCCESS".equals(failureType = (String)runJob.get("type"))) continue;
                    res.add(runJob);
                    continue;
                }
                log.warn((Object)("Ignoring failing job at " + runUrl));
            }
        }
        return res;
    }

    public static Map<String, Serializable> convertBuild(JSONObject jsonBuild) throws IOException {
        String description;
        HashMap<String, Serializable> build = new HashMap<String, Serializable>();
        build.put("build_number", (Serializable)((Object)String.valueOf(jsonBuild.optInt("number"))));
        String comment = null;
        JSONArray actions = jsonBuild.optJSONArray("actions");
        if (actions != null) {
            for (Object jsonAction : actions) {
                if (jsonAction == null || !((JSONObject)jsonAction).has("claimed")) continue;
                JSONObject claim = (JSONObject)jsonAction;
                if (!claim.optBoolean("claimed")) break;
                build.put("claimer", (Serializable)((Object)claim.optString("claimedBy")));
                String reason = claim.optString("reason");
                if (JenkinsJsonConverter.isEmpty(reason)) break;
                comment = "Claim reason: " + reason;
                break;
            }
        }
        if (!JenkinsJsonConverter.isEmpty(description = jsonBuild.optString("description"))) {
            comment = comment != null ? comment + "\n\n" : "";
            comment = comment + "Description: " + description;
        }
        build.put("comment", (Serializable)((Object)comment));
        ArrayList<String> culprits = new ArrayList<String>();
        JSONArray jsonCulprits = jsonBuild.optJSONArray("culprits");
        if (jsonCulprits != null) {
            for (Object jsonCulprit : jsonCulprits) {
                String name;
                if (jsonCulprit == null || JenkinsJsonConverter.isEmpty(name = ((JSONObject)jsonCulprit).optString("fullName")) || "jenkins".equals(name)) continue;
                culprits.add(name);
            }
        }
        build.put("culprits", culprits);
        build.put("type", (Serializable)((Object)jsonBuild.optString("result")));
        return build;
    }

    public static List<Map<String, Serializable>> mergeData(List<Map<String, Serializable>> oldData, List<Map<String, Serializable>> newData) {
        LinkedHashMap<String, Map<String, Serializable>> res = new LinkedHashMap<String, Map<String, Serializable>>();
        if (oldData != null) {
            for (Map<String, Serializable> item : oldData) {
                res.put((String)((Object)item.get("job_id")), item);
            }
        }
        if (newData != null) {
            for (Map<String, Serializable> item : newData) {
                String id = (String)((Object)item.get("job_id"));
                String build_number = (String)((Object)item.get("build_number"));
                if (res.containsKey(id)) {
                    Map oldItem = (Map)((HashMap)res).get(id);
                    String oldBuildNumber = String.valueOf(oldItem.get("build_number"));
                    if (build_number != null && build_number.equals(oldBuildNumber)) {
                        oldItem.put("claimer", item.get("claimer"));
                        oldItem.put("comment", item.get("comment"));
                        res.put(id, oldItem);
                        continue;
                    }
                    oldItem.put("updated_build_number", build_number);
                    oldItem.put("updated_type", item.get("type"));
                    oldItem.put("claimer", item.get("claimer"));
                    String oldComment = String.valueOf(oldItem.get("comment"));
                    String newComent = String.valueOf(item.get("comment"));
                    if (oldComment != null) {
                        if (newComent != null && !newComent.equals(oldComment)) {
                            String mergedComment = String.format("Comments for build %s:\n%s\n\nComments for build %s:\n%s", oldBuildNumber, oldComment, build_number, newComent);
                            oldItem.put("comment", mergedComment);
                        }
                    } else if (newComent != null) {
                        oldItem.put("comment", newComent);
                    }
                    oldItem.put("cause", item.get("code"));
                    res.put(id, oldItem);
                    continue;
                }
                res.put(id, item);
            }
        }
        return new ArrayList<Map<String, Serializable>>(((HashMap)res).values());
    }

    protected static boolean isEmpty(String value) {
        return StringUtils.isBlank((String)value) || "null".equals(value);
    }
}

