/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.query;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.query.api.AbstractPageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PredicateDefinition;
import org.nuxeo.ecm.platform.query.api.PredicateFieldDefinition;
import org.nuxeo.ecm.platform.query.api.WhereClauseDefinition;
import org.nuxeo.ecm.platform.query.nxql.NXQLQueryBuilder;

public class ComplexListPropertyPageProvider
extends AbstractPageProvider<Map<String, Object>> {
    private static final long serialVersionUID = 1L;
    protected List<Map<String, Object>> items;
    protected List<Map<String, Object>> currentItems;
    static final Collator collator = Collator.getInstance();

    public List<Map<String, Object>> getCurrentPage() {
        if (this.currentItems == null) {
            this.currentItems = new ArrayList<Map<String, Object>>();
            try {
                if (this.items == null) {
                    Object[] parameters = this.getParameters();
                    if (parameters == null) {
                        throw new ClientException("First parameter needed to resolve the list of items");
                    }
                    this.items = (List)parameters[0];
                }
                ArrayList<Map<String, Object>> allItems = new ArrayList<Map<String, Object>>();
                boolean noFilter = true;
                PageProviderDefinition def = this.getDefinition();
                WhereClauseDefinition wc = def.getWhereClause();
                if (wc != null) {
                    DocumentModel doc = this.getSearchDocumentModel();
                    if (doc == null) {
                        throw new ClientException(String.format("Cannot build query of provider '%s': no search document model is set", this.getName()));
                    }
                    PredicateDefinition[] predicates = wc.getPredicates();
                    if (predicates != null) {
                        HashMap<String, Object> filters = new HashMap<String, Object>();
                        for (PredicateDefinition pred : predicates) {
                            Object operator = null;
                            String operatorField = pred.getOperatorField();
                            String operatorSchema = pred.getOperatorSchema();
                            String parameter = pred.getParameter();
                            PredicateFieldDefinition[] values = pred.getValues();
                            Object value = NXQLQueryBuilder.getRawValue((DocumentModel)doc, (PredicateFieldDefinition)values[0]);
                            if (value == null) continue;
                            filters.put(parameter, value);
                        }
                        if (!filters.isEmpty()) {
                            noFilter = false;
                            for (Map map : this.items) {
                                for (Map.Entry filter : filters.entrySet()) {
                                    if (!this.matches(map, (String)filter.getKey(), filter.getValue())) break;
                                    allItems.add(map);
                                }
                            }
                        }
                    }
                }
                if (noFilter && this.items != null) {
                    allItems.addAll(this.items);
                }
                if (this.sortInfos != null) {
                    Collections.sort(allItems, new MapComparator(this.sortInfos));
                }
                long minMaxPageSize = this.getMinMaxPageSize();
                long offset = this.getCurrentPageOffset();
                long l = allItems.size();
                this.setResultsCount(l);
                int index = 0;
                if (offset < l) {
                    index = Long.valueOf(offset).intValue();
                }
                int pos = 0;
                for (int i = index; i < allItems.size() && (long)pos < minMaxPageSize; ++i) {
                    ++pos;
                    this.currentItems.add((Map<String, Object>)allItems.get(i));
                }
            }
            catch (ClientException e) {
                this.error = e;
                this.errorMessage = e.getMessage();
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.currentItems;
    }

    protected boolean matches(Map<String, Object> item, String key, Object value) {
        return item.containsKey(key) && value.equals(item.get(key));
    }

    protected void pageChanged() {
        this.currentItems = null;
        super.pageChanged();
    }

    public void refresh() {
        this.items = null;
        this.currentItems = null;
        super.refresh();
    }

    static {
        collator.setStrength(0);
    }

    public class MapComparator
    implements Comparator<Map<String, Object>> {
        protected List<SortInfo> sortInfos;

        public MapComparator(List<SortInfo> sortInfos) {
            this.sortInfos = sortInfos;
        }

        @Override
        public int compare(Map<String, Object> arg0, Map<String, Object> arg1) {
            if (this.sortInfos != null) {
                for (SortInfo sortInfo : this.sortInfos) {
                    boolean sortAsc;
                    String sortColumn = sortInfo.getSortColumn();
                    int res = this.compare(arg0, arg1, sortColumn, sortAsc = sortInfo.getSortAscending());
                    if (res == 0) continue;
                    return res;
                }
            }
            return 0;
        }

        protected int compare(Map<String, Object> arg0, Map<String, Object> arg1, String sortColumn, boolean asc) {
            Object v1 = arg0.get(sortColumn);
            Object v2 = arg1.get(sortColumn);
            if (v1 == null && v2 == null) {
                return 0;
            }
            if (v1 == null) {
                return asc ? -1 : 1;
            }
            if (v2 == null) {
                return asc ? 1 : -1;
            }
            int cmp = v1 instanceof Long && v2 instanceof Long ? ((Long)v1).compareTo((Long)v2) : (v1 instanceof Integer && v2 instanceof Integer ? ((Integer)v1).compareTo((Integer)v2) : collator.compare(v1.toString(), v2.toString()));
            return asc ? cmp : -cmp;
        }
    }
}

