/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.select2.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.features.SuggestConstants;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.query.sql.NXQL;

public class Select2Common
extends SuggestConstants {
    private static final Log log = LogFactory.getLog(Select2Common.class);
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String LOCKED = "locked";
    public static final String PLACEHOLDER = "placeholder";
    public static final List<String> SELECT2_USER_WIDGET_TYPE_LIST = new ArrayList<String>(Arrays.asList("singleUserSuggestion", "multipleUsersSuggestion"));
    public static final List<String> SELECT2_DOC_WIDGET_TYPE_LIST = new ArrayList<String>(Arrays.asList("singleDocumentSuggestion", "multipleDocumentsSuggestion"));
    public static final String SUGGESTION_FORMATTER = "suggestionFormatter";
    public static final String SELECTION_FORMATTER = "selectionFormatter";
    public static final String USER_DEFAULT_SUGGESTION_FORMATTER = "userEntryDefaultFormatter";
    public static final String DOC_DEFAULT_SUGGESTION_FORMATTER = "docEntryDefaultFormatter";
    public static final List<String> SELECT2_DIR_WIDGET_TYPE_LIST = new ArrayList<String>(Arrays.asList("suggestOneDirectory", "suggestManyDirectory"));
    public static final List<String> SELECT2_DEFAULT_DOCUMENT_SCHEMAS = new ArrayList<String>(Arrays.asList("dublincore", "common"));
    public static final String DIR_DEFAULT_SUGGESTION_FORMATTER = "dirEntryDefaultFormatter";
    public static final String READ_ONLY_PARAM = "readonly";
    public static final String RERENDER_JS_FUNCTION_NAME = "reRenderFunctionName";
    public static final String AJAX_RERENDER = "ajaxReRender";
    public static final String USER_DEFAULT_SELECTION_FORMATTER = "userSelectionDefaultFormatter";
    public static final String DOC_DEFAULT_SELECTION_FORMATTER = "docSelectionDefaultFormatter";
    public static final String DIR_DEFAULT_SELECTION_FORMATTER = "dirSelectionDefaultFormatter";
    public static final String WIDTH = "width";
    public static final String DEFAULT_WIDTH = "300";
    public static final String MIN_CHARS = "minChars";
    public static final int DEFAULT_MIN_CHARS = 3;
    public static final String TITLE = "title";
    public static final String OPERATION_ID = "operationId";

    private Select2Common() {
    }

    public static String[] getDefaultSchemas() {
        return Select2Common.getSchemas(null);
    }

    public static String[] getSchemas(String schemaNames) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(SELECT2_DEFAULT_DOCUMENT_SCHEMAS);
        String[] temp = null;
        if (schemaNames != null && !schemaNames.isEmpty()) {
            temp = schemaNames.split(",");
        }
        if (temp != null) {
            for (String s : temp) {
                result.add(s);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static String resolveDefaultEntries(List<String> list) {
        if (list == null || list.isEmpty()) {
            return "[]";
        }
        try {
            ArrayList result = new ArrayList();
            for (String l : list) {
                LinkedHashMap<String, String> obj = new LinkedHashMap<String, String>();
                obj.put("id", l);
                obj.put("displayLabel", l);
                result.add(obj);
            }
            return OBJECT_MAPPER.writeValueAsString(result);
        }
        catch (IOException e) {
            throw new NuxeoException("Unable to serialize json", (Throwable)e);
        }
    }

    public static DocumentModel resolveReference(String property, String value, CoreSession session) {
        if (property != null && !property.isEmpty()) {
            String query = "select * from Document where " + property + "=" + NXQL.escapeString((String)value);
            DocumentModelList docs = session.query(query);
            if (docs.size() > 0) {
                return (DocumentModel)docs.get(0);
            }
            log.warn((Object)("Unable to resolve doc using property " + property + " and value " + value));
            return null;
        }
        Object ref = null;
        ref = value.startsWith("/") ? new PathRef(value) : new IdRef(value);
        if (session.exists((DocumentRef)ref)) {
            return session.getDocument((DocumentRef)ref);
        }
        log.warn((Object)("Unable to resolve reference on " + ref));
        return null;
    }
}

