/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.png;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.ZLibUtils;
import org.apache.sanselan.formats.png.PngConstants;
import org.apache.sanselan.formats.png.PngCrc;
import org.apache.sanselan.formats.png.PngText;
import org.apache.sanselan.palette.MedianCutQuantizer;
import org.apache.sanselan.palette.Palette;
import org.apache.sanselan.palette.PaletteFactory;
import org.apache.sanselan.util.Debug;
import org.apache.sanselan.util.ParamMap;
import org.apache.sanselan.util.UnicodeUtils;

public class PngWriter
implements PngConstants {
    private final boolean verbose;

    public PngWriter(boolean verbose) {
        this.verbose = verbose;
    }

    public PngWriter(Map params) {
        this.verbose = ParamMap.getParamBoolean(params, "VERBOSE", false);
    }

    private final void writeInt(OutputStream os, int value) throws IOException {
        os.write(0xFF & value >> 24);
        os.write(0xFF & value >> 16);
        os.write(0xFF & value >> 8);
        os.write(0xFF & value >> 0);
    }

    private final void writeChunk(OutputStream os, byte[] chunkType, byte[] data) throws IOException {
        int dataLength = data == null ? 0 : data.length;
        this.writeInt(os, dataLength);
        os.write(chunkType);
        if (data != null) {
            os.write(data);
        }
        PngCrc png_crc = new PngCrc();
        long crc1 = png_crc.start_partial_crc(chunkType, chunkType.length);
        long crc2 = data == null ? crc1 : png_crc.continue_partial_crc(crc1, data, data.length);
        int crc = (int)png_crc.finish_partial_crc(crc2);
        this.writeInt(os, crc);
    }

    private void writeChunkIHDR(OutputStream os, ImageHeader value) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeInt(baos, value.width);
        this.writeInt(baos, value.height);
        baos.write(0xFF & value.bit_depth);
        baos.write(0xFF & value.colorType);
        baos.write(0xFF & value.compressionMethod);
        baos.write(0xFF & value.filterMethod);
        baos.write(0xFF & value.interlaceMethod);
        this.writeChunk(os, IHDR_CHUNK_TYPE, baos.toByteArray());
    }

    private void writeChunkiTXt(OutputStream os, PngText.iTXt text) throws IOException, ImageWriteException {
        if (!UnicodeUtils.isValidISO_8859_1(text.keyword)) {
            throw new ImageWriteException("Png tEXt chunk keyword is not ISO-8859-1: " + text.keyword);
        }
        if (!UnicodeUtils.isValidISO_8859_1(text.languageTag)) {
            throw new ImageWriteException("Png tEXt chunk language tag is not ISO-8859-1: " + text.languageTag);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(text.keyword.getBytes("ISO-8859-1"));
        baos.write(0);
        baos.write(1);
        baos.write(0);
        baos.write(text.languageTag.getBytes("ISO-8859-1"));
        baos.write(0);
        baos.write(text.translatedKeyword.getBytes("utf-8"));
        baos.write(0);
        baos.write(new ZLibUtils().deflate(text.text.getBytes("utf-8")));
        this.writeChunk(os, iTXt_CHUNK_TYPE, baos.toByteArray());
    }

    private void writeChunkzTXt(OutputStream os, PngText.zTXt text) throws IOException, ImageWriteException {
        if (!UnicodeUtils.isValidISO_8859_1(text.keyword)) {
            throw new ImageWriteException("Png zTXt chunk keyword is not ISO-8859-1: " + text.keyword);
        }
        if (!UnicodeUtils.isValidISO_8859_1(text.text)) {
            throw new ImageWriteException("Png zTXt chunk text is not ISO-8859-1: " + text.text);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(text.keyword.getBytes("ISO-8859-1"));
        baos.write(0);
        baos.write(0);
        baos.write(new ZLibUtils().deflate(text.text.getBytes("ISO-8859-1")));
        this.writeChunk(os, zTXt_CHUNK_TYPE, baos.toByteArray());
    }

    private void writeChunktEXt(OutputStream os, PngText.tEXt text) throws IOException, ImageWriteException {
        if (!UnicodeUtils.isValidISO_8859_1(text.keyword)) {
            throw new ImageWriteException("Png tEXt chunk keyword is not ISO-8859-1: " + text.keyword);
        }
        if (!UnicodeUtils.isValidISO_8859_1(text.text)) {
            throw new ImageWriteException("Png tEXt chunk text is not ISO-8859-1: " + text.text);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(text.keyword.getBytes("ISO-8859-1"));
        baos.write(0);
        baos.write(text.text.getBytes("ISO-8859-1"));
        this.writeChunk(os, tEXt_CHUNK_TYPE, baos.toByteArray());
    }

    private void writeChunkXmpiTXt(OutputStream os, String xmpXml) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write("XML:com.adobe.xmp".getBytes("ISO-8859-1"));
        baos.write(0);
        baos.write(1);
        baos.write(0);
        baos.write(0);
        baos.write("XML:com.adobe.xmp".getBytes("utf-8"));
        baos.write(0);
        baos.write(new ZLibUtils().deflate(xmpXml.getBytes("utf-8")));
        this.writeChunk(os, iTXt_CHUNK_TYPE, baos.toByteArray());
    }

    private void writeChunkPLTE(OutputStream os, Palette palette) throws IOException {
        int length = palette.length();
        byte[] bytes = new byte[length * 3];
        for (int i = 0; i < length; ++i) {
            int rgb = palette.getEntry(i);
            int index = i * 3;
            bytes[index + 0] = (byte)(0xFF & rgb >> 16);
            bytes[index + 1] = (byte)(0xFF & rgb >> 8);
            bytes[index + 2] = (byte)(0xFF & rgb >> 0);
        }
        this.writeChunk(os, PLTE_CHUNK_TYPE, bytes);
    }

    private void writeChunkIEND(OutputStream os) throws IOException {
        this.writeChunk(os, IEND_CHUNK_TYPE, null);
    }

    private void writeChunkIDAT(OutputStream os, byte[] bytes) throws IOException {
        this.writeChunk(os, IDAT_CHUNK_TYPE, bytes);
    }

    private byte getColourType(boolean hasAlpha, boolean isGrayscale) {
        boolean index = false;
        int result = index ? 3 : (isGrayscale ? (hasAlpha ? 4 : 0) : (hasAlpha ? 6 : 2));
        return (byte)result;
    }

    private byte getBitDepth(byte colorType, Map params) {
        byte result = 8;
        Object o = params.get("PNG_BIT_DEPTH");
        if (o != null && o instanceof Number) {
            int value = ((Number)o).intValue();
            switch (value) {
                case 1: 
                case 2: 
                case 4: 
                case 8: 
                case 16: {
                    result = (byte)value;
                }
            }
            switch (colorType) {
                case 0: {
                    break;
                }
                case 3: {
                    result = (byte)Math.min(8, result);
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    result = (byte)Math.max(8, result);
                    break;
                }
            }
        }
        return result;
    }

    public void writeImage(BufferedImage src, OutputStream os, Map params) throws ImageWriteException, IOException {
        if ((params = new HashMap(params)).containsKey("FORMAT")) {
            params.remove("FORMAT");
        }
        if (params.containsKey("VERBOSE")) {
            params.remove("VERBOSE");
        }
        HashMap rawParams = new HashMap(params);
        if (params.containsKey("PNG_FORCE_TRUE_COLOR")) {
            params.remove("PNG_FORCE_TRUE_COLOR");
        }
        if (params.containsKey("PNG_FORCE_INDEXED_COLOR")) {
            params.remove("PNG_FORCE_INDEXED_COLOR");
        }
        if (params.containsKey("PNG_BIT_DEPTH")) {
            params.remove("PNG_BIT_DEPTH");
        }
        if (params.containsKey("XMP_XML")) {
            params.remove("XMP_XML");
        }
        if (params.containsKey("PNG_TEXT_CHUNKS")) {
            params.remove("PNG_TEXT_CHUNKS");
        }
        if (params.size() > 0) {
            Object firstKey = params.keySet().iterator().next();
            throw new ImageWriteException("Unknown parameter: " + firstKey);
        }
        params = rawParams;
        int width = src.getWidth();
        int height = src.getHeight();
        boolean hasAlpha = new PaletteFactory().hasTransparency(src);
        if (this.verbose) {
            Debug.debug("hasAlpha", hasAlpha);
        }
        boolean isGrayscale = new PaletteFactory().isGrayscale(src);
        if (this.verbose) {
            Debug.debug("isGrayscale", isGrayscale);
        }
        boolean forceIndexedColor = ParamMap.getParamBoolean(params, "PNG_FORCE_INDEXED_COLOR", false);
        boolean forceTrueColor = ParamMap.getParamBoolean(params, "PNG_FORCE_TRUE_COLOR", false);
        if (forceIndexedColor && forceTrueColor) {
            throw new ImageWriteException("Params: Cannot force both indexed and true color modes");
        }
        byte colorType = forceIndexedColor ? (byte)3 : (forceTrueColor ? (byte)((byte)(hasAlpha ? 6 : 2)) : (byte)this.getColourType(hasAlpha, isGrayscale));
        if (this.verbose) {
            Debug.debug("colorType", (int)colorType);
        }
        byte bitDepth = this.getBitDepth(colorType, params);
        if (this.verbose) {
            Debug.debug("bit_depth", (int)bitDepth);
        }
        int sampleDepth = colorType == 3 ? 8 : (int)bitDepth;
        if (this.verbose) {
            Debug.debug("sample_depth", sampleDepth);
        }
        os.write(PNG_Signature);
        byte compressionMethod = 0;
        byte filterMethod = 0;
        byte interlaceMethod = 0;
        ImageHeader imageHeader = new ImageHeader(width, height, bitDepth, colorType, compressionMethod, filterMethod, interlaceMethod);
        this.writeChunkIHDR(os, imageHeader);
        Palette palette = null;
        if (colorType == 3) {
            int max_colors = hasAlpha ? 255 : 256;
            palette = new MedianCutQuantizer(true).process(src, max_colors, this.verbose);
            this.writeChunkPLTE(os, palette);
        }
        if (params.containsKey("XMP_XML")) {
            String xmpXml = (String)params.get("XMP_XML");
            this.writeChunkXmpiTXt(os, xmpXml);
        }
        if (params.containsKey("PNG_TEXT_CHUNKS")) {
            List outputTexts = (List)params.get("PNG_TEXT_CHUNKS");
            for (int i = 0; i < outputTexts.size(); ++i) {
                PngText text = (PngText)outputTexts.get(i);
                if (text instanceof PngText.tEXt) {
                    this.writeChunktEXt(os, (PngText.tEXt)text);
                    continue;
                }
                if (text instanceof PngText.zTXt) {
                    this.writeChunkzTXt(os, (PngText.zTXt)text);
                    continue;
                }
                if (text instanceof PngText.iTXt) {
                    this.writeChunkiTXt(os, (PngText.iTXt)text);
                    continue;
                }
                throw new ImageWriteException("Unknown text to embed in PNG: " + text);
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean useAlpha = colorType == 4 || colorType == 6;
        int[] row = new int[width];
        for (int y = 0; y < height; ++y) {
            src.getRGB(0, y, width, 1, row, 0, width);
            int filter_type = 0;
            baos.write(filter_type);
            for (int x = 0; x < width; ++x) {
                int argb = row[x];
                if (palette != null) {
                    int index = palette.getPaletteIndex(argb);
                    baos.write(0xFF & index);
                    continue;
                }
                int alpha = 0xFF & argb >> 24;
                int red = 0xFF & argb >> 16;
                int green = 0xFF & argb >> 8;
                int blue = 0xFF & argb >> 0;
                if (isGrayscale) {
                    int gray = (red + green + blue) / 3;
                    baos.write(gray);
                } else {
                    baos.write(red);
                    baos.write(green);
                    baos.write(blue);
                }
                if (!useAlpha) continue;
                baos.write(alpha);
            }
        }
        byte[] uncompressed = baos.toByteArray();
        baos = new ByteArrayOutputStream();
        DeflaterOutputStream dos = new DeflaterOutputStream(baos);
        int chunk_size = 262144;
        for (int index = 0; index < uncompressed.length; index += chunk_size) {
            int end = Math.min(uncompressed.length, index + chunk_size);
            int length = end - index;
            dos.write(uncompressed, index, length);
            dos.flush();
            baos.flush();
            byte[] compressed = baos.toByteArray();
            baos.reset();
            if (compressed.length <= 0) continue;
            this.writeChunkIDAT(os, compressed);
        }
        dos.finish();
        byte[] compressed = baos.toByteArray();
        if (compressed.length > 0) {
            this.writeChunkIDAT(os, compressed);
        }
        this.writeChunkIEND(os);
        os.close();
    }

    private static class ImageHeader {
        public final int width;
        public final int height;
        public final byte bit_depth;
        public final byte colorType;
        public final byte compressionMethod;
        public final byte filterMethod;
        public final byte interlaceMethod;

        public ImageHeader(int width, int height, byte bit_depth, byte colorType, byte compressionMethod, byte filterMethod, byte interlaceMethod) {
            this.width = width;
            this.height = height;
            this.bit_depth = bit_depth;
            this.colorType = colorType;
            this.compressionMethod = compressionMethod;
            this.filterMethod = filterMethod;
            this.interlaceMethod = interlaceMethod;
        }
    }
}

