/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.filemanager;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.RecoverableClientException;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.platform.filemanager.api.FileImporterContext;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.UserAction;
import org.nuxeo.ecm.platform.ui.web.util.files.FileUtils;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.ExceptionHelper;
import org.nuxeo.ecm.webapp.clipboard.ClipboardActions;
import org.nuxeo.ecm.webapp.contentbrowser.DocumentActions;
import org.nuxeo.ecm.webapp.filemanager.FileManageActions;
import org.nuxeo.ecm.webapp.filemanager.NxUploadedFile;
import org.nuxeo.ecm.webapp.filemanager.UploadItemHolder;
import org.nuxeo.ecm.webapp.filemanager.UploadItemHolderCycleManager;
import org.nuxeo.ecm.webapp.helpers.EventManager;
import org.nuxeo.runtime.api.Framework;
import org.richfaces.event.FileUploadEvent;
import org.richfaces.model.UploadedFile;

@Name(value="FileManageActions")
@Scope(value=ScopeType.EVENT)
@Install(precedence=10)
public class FileManageActionsBean
implements FileManageActions {
    private static final Log log = LogFactory.getLog(FileManageActionsBean.class);
    public static final String TRANSF_ERROR = "TRANSF_ERROR";
    public static final String SECURITY_ERROR = "SECURITY_ERROR";
    public static final String MOVE_ERROR = "MOVE_ERROR";
    public static final String COPY_ERROR = "COPY_ERROR";
    public static final String PASTE_ERROR = "PASTE_ERROR";
    public static final String MOVE_IMPOSSIBLE = "MOVE_IMPOSSIBLE";
    public static final String MOVE_PUBLISH = "MOVE_PUBLISH";
    public static final String MOVE_OK = "MOVE_OK";
    protected static final String FILES_SCHEMA = "files";
    protected static final String FILES_PROPERTY = "files:files";
    protected static final String SECTION_DOCTYPE = "Section";
    @In(create=true, required=false)
    protected CoreSession documentManager;
    @In(create=true)
    protected TypeManager typeManager;
    @In(create=true)
    protected NavigationContext navigationContext;
    @In(create=true)
    protected transient DocumentActions documentActions;
    @In(create=true)
    protected ClipboardActions clipboardActions;
    @In(create=true, required=false)
    protected UploadItemHolder fileUploadHolder;
    @In(create=true, required=false)
    protected UploadItemHolderCycleManager fileUploadHolderCycle;
    protected String fileToRemove;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected Map<String, String> messages;
    protected FileManager fileManager;
    protected List<String> tmpFilePaths = new ArrayList<String>();

    protected FileManager getFileManagerService() {
        if (this.fileManager == null) {
            this.fileManager = (FileManager)Framework.getService(FileManager.class);
        }
        return this.fileManager;
    }

    @Override
    public String display() {
        return "view_documents";
    }

    @Override
    public String addFile() {
        NxUploadedFile uploadedFile = this.fileUploadHolder.getUploadedFiles().iterator().next();
        Blob blob = uploadedFile.getBlob();
        if (blob == null || blob.getFilename() == null) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("fileImporter.error.nullUploadedFile"), new Object[0]);
            return this.navigationContext.getActionResult(this.navigationContext.getCurrentDocument(), UserAction.AFTER_CREATE);
        }
        FileUtils.configureFileBlob((Blob)blob);
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        String path = currentDocument.getPathAsString();
        DocumentModel createdDoc = null;
        try {
            FileImporterContext context = FileImporterContext.builder((CoreSession)this.documentManager, (Blob)blob, (String)path).overwrite(true).build();
            createdDoc = this.getFileManagerService().createOrUpdateDocument(context);
        }
        catch (IOException e) {
            throw new NuxeoException("Can not write blob for" + blob.getFilename(), (Throwable)e);
        }
        EventManager.raiseEventsOnDocumentSelected((DocumentModel)createdDoc);
        Events.instance().raiseEvent("documentChildrenChanged", new Object[]{currentDocument});
        this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get("document_saved"), new Object[]{this.messages.get(createdDoc.getType())});
        return this.navigationContext.getActionResult(createdDoc, UserAction.AFTER_CREATE);
    }

    @Override
    @Deprecated
    @WebRemote
    public boolean canWrite() {
        return true;
    }

    protected String getErrorMessage(String errorType, String errorInfo) {
        return this.getErrorMessage(errorType, errorInfo, "message.operation.fails.generic");
    }

    protected String getErrorMessage(String errorType, String errorInfo, String errorLabel) {
        return String.format("%s |(%s)| %s", errorType, errorInfo, this.messages.get(errorLabel));
    }

    @Override
    @Deprecated
    @WebRemote
    public String addFileFromPlugin(String content, String mimetype, String fullName, String morePath, Boolean UseBase64) {
        byte[] bcontent = UseBase64 != false ? Base64.decodeBase64((String)content) : content.getBytes();
        return this.addBinaryFileFromPlugin(bcontent, mimetype, fullName, morePath);
    }

    @WebRemote
    public String addBinaryFileFromPlugin(Blob blob, String fullName, String morePath) {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        String curPath = currentDocument.getPathAsString();
        String path = curPath + morePath;
        return this.createDocumentFromBlob(blob, fullName, path);
    }

    @WebRemote
    public String addBinaryFileFromPlugin(Blob blob, String fullName, DocumentModel targetContainer) {
        return this.createDocumentFromBlob(blob, fullName, targetContainer.getPathAsString());
    }

    protected String createDocumentFromBlob(Blob blob, String fullName, String path) {
        DocumentModel createdDoc;
        try {
            FileImporterContext context = FileImporterContext.builder((CoreSession)this.documentManager, (Blob)blob, (String)path).overwrite(true).fileName(fullName).build();
            createdDoc = this.getFileManagerService().createOrUpdateDocument(context);
        }
        catch (IOException | NuxeoException t) {
            Throwable unwrappedError = ExceptionHelper.unwrapException((Throwable)t);
            if (ExceptionHelper.isSecurityError((Throwable)unwrappedError)) {
                log.debug((Object)("No permissions creating " + fullName));
                return this.getErrorMessage(SECURITY_ERROR, fullName, "Error.Insuffisant.Rights");
            }
            log.error((Object)("Error importing " + fullName), t);
            return this.getErrorMessage(TRANSF_ERROR, fullName);
        }
        if (createdDoc == null) {
            log.error((Object)("could not create the document " + fullName));
            return this.getErrorMessage(TRANSF_ERROR, fullName);
        }
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument.getRef().equals(createdDoc.getRef())) {
            this.navigationContext.updateDocumentContext(createdDoc);
        }
        Events.instance().raiseEvent("documentChildrenChanged", new Object[]{currentDocument});
        EventManager.raiseEventsOnDocumentSelected((DocumentModel)createdDoc);
        return createdDoc.getName();
    }

    @Deprecated
    public String addBinaryFileFromPlugin(byte[] content, String mimetype, String fullName, String morePath) {
        Blob blob = Blobs.createBlob((byte[])content);
        return this.addBinaryFileFromPlugin(blob, fullName, morePath);
    }

    @Override
    @WebRemote
    public String addFolderFromPlugin(String fullName, String morePath) {
        try {
            DocumentModel createdDoc;
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            String curPath = currentDocument.getPathAsString();
            if (!currentDocument.isFolder()) {
                curPath = curPath.substring(0, curPath.lastIndexOf(47));
            }
            String path = curPath + morePath;
            try {
                createdDoc = this.getFileManagerService().createFolder(this.documentManager, fullName, path, true);
            }
            catch (IOException | NuxeoException t) {
                Throwable unwrappedError = ExceptionHelper.unwrapException((Throwable)t);
                if (ExceptionHelper.isSecurityError((Throwable)unwrappedError)) {
                    log.debug((Object)("No permissions creating folder " + fullName));
                    return this.getErrorMessage(SECURITY_ERROR, fullName, "Error.Insuffisant.Rights");
                }
                log.error((Object)("Couldn't create the folder " + fullName));
                return this.getErrorMessage(TRANSF_ERROR, fullName);
            }
            if (createdDoc == null) {
                log.error((Object)("Couldn't create the folder " + fullName));
                return this.getErrorMessage(TRANSF_ERROR, fullName);
            }
            EventManager.raiseEventsOnDocumentSelected((DocumentModel)createdDoc);
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{currentDocument});
            return createdDoc.getName();
        }
        catch (RecoverableClientException e) {
            throw e;
        }
        catch (NuxeoException e) {
            throw new RecoverableClientException("Cannot validate, caught exception", "error.db.fs", null, (Throwable)e);
        }
    }

    @WebRemote
    protected String checkMoveAllowed(DocumentRef docRef, DocumentRef containerRef) {
        DocumentModel doc = this.documentManager.getDocument(docRef);
        DocumentModel container = this.documentManager.getDocument(containerRef);
        if ((container.getPathAsString() + "/").startsWith(doc.getPathAsString() + "/")) {
            this.facesMessages.add(StatusMessage.Severity.WARN, this.messages.get("move_impossible"), new Object[0]);
            return MOVE_IMPOSSIBLE;
        }
        if (!doc.isProxy() && container.hasFacet("PublishSpace") && !doc.hasFacet("PublishSpace")) {
            if (!this.documentManager.hasPermission(containerRef, "AddChildren")) {
                this.facesMessages.add(StatusMessage.Severity.WARN, this.messages.get("move_insuffisant_rights"), new Object[0]);
                return MOVE_IMPOSSIBLE;
            }
            if (doc.hasFacet("Publishable")) {
                return MOVE_PUBLISH;
            }
            this.facesMessages.add(StatusMessage.Severity.WARN, this.messages.get("publish_impossible"), new Object[0]);
            return MOVE_IMPOSSIBLE;
        }
        if (!this.documentManager.hasPermission(doc.getParentRef(), "RemoveChildren") || !this.documentManager.hasPermission(doc.getRef(), "Remove")) {
            this.facesMessages.add(StatusMessage.Severity.WARN, this.messages.get("move_impossible"), new Object[0]);
            return MOVE_IMPOSSIBLE;
        }
        if (!this.documentManager.hasPermission(containerRef, "AddChildren")) {
            this.facesMessages.add(StatusMessage.Severity.WARN, this.messages.get("move_insuffisant_rights"), new Object[0]);
            return MOVE_IMPOSSIBLE;
        }
        if (doc.isProxy()) {
            if (!container.hasFacet("PublishSpace")) {
                this.facesMessages.add(StatusMessage.Severity.WARN, this.messages.get("move_impossible"), new Object[0]);
                return MOVE_IMPOSSIBLE;
            }
        } else if (!this.typeManager.isAllowedSubType(doc.getType(), container.getType(), container)) {
            this.facesMessages.add(StatusMessage.Severity.WARN, this.messages.get("move_impossible"), new Object[0]);
            return MOVE_IMPOSSIBLE;
        }
        return MOVE_OK;
    }

    @Override
    @WebRemote
    public String moveWithId(String docId, String containerId) {
        try {
            IdRef dstRef;
            String moveStatus;
            String debug = "move " + docId + " into " + containerId;
            log.debug((Object)debug);
            if (docId.startsWith("docRef:")) {
                docId = docId.split("docRef:")[1];
            }
            if (docId.startsWith("docClipboardRef:")) {
                docId = docId.split("docClipboardRef:")[1];
            }
            IdRef srcRef = new IdRef(docId);
            String dst = containerId;
            if (dst.startsWith("docRef:")) {
                dst = dst.split("docRef:")[1];
            }
            if (dst.startsWith("nodeRef:")) {
                dst = dst.split("nodeRef:")[1];
            }
            if ((moveStatus = this.checkMoveAllowed((DocumentRef)srcRef, (DocumentRef)(dstRef = new IdRef(dst)))).equals(MOVE_IMPOSSIBLE)) {
                return debug;
            }
            String action = "document_moved";
            if (moveStatus.equals(MOVE_PUBLISH)) {
                DocumentModel srcDoc = this.documentManager.getDocument((DocumentRef)srcRef);
                DocumentModel dstDoc = this.documentManager.getDocument((DocumentRef)dstRef);
                this.documentManager.publishDocument(srcDoc, dstDoc);
                action = "document_published";
            } else {
                this.documentManager.move((DocumentRef)srcRef, (DocumentRef)dstRef, null);
            }
            this.documentManager.save();
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            EventManager.raiseEventsOnDocumentChildrenChange((DocumentModel)currentDocument);
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{currentDocument});
            DocumentModel otherContainer = this.documentManager.getDocument((DocumentRef)dstRef);
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{otherContainer});
            this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get(action), new Object[]{this.messages.get(this.documentManager.getDocument((DocumentRef)srcRef).getType())});
            return debug;
        }
        catch (RecoverableClientException e) {
            throw e;
        }
        catch (NuxeoException e) {
            throw new RecoverableClientException("Cannot validate, caught exception", "message.operation.fails.generic", null, (Throwable)e);
        }
    }

    @Override
    @WebRemote
    public String copyWithId(String docId) {
        try {
            String debug = "copying " + docId;
            log.debug((Object)debug);
            if (docId.startsWith("docRef:")) {
                docId = docId.split("docRef:")[1];
            }
            if (docId.startsWith("docClipboardRef:")) {
                docId = docId.split("docClipboardRef:")[1];
            }
            IdRef srcRef = new IdRef(docId);
            DocumentModel srcDoc = this.documentManager.getDocument((DocumentRef)srcRef);
            ArrayList<DocumentModel> docsToAdd = new ArrayList<DocumentModel>();
            docsToAdd.add(srcDoc);
            this.clipboardActions.putSelectionInWorkList(docsToAdd, Boolean.TRUE);
            return debug;
        }
        catch (RecoverableClientException e) {
            throw e;
        }
        catch (NuxeoException e) {
            throw new RecoverableClientException("Cannot validate, caught exception", "message.operation.fails.generic", null, (Throwable)e);
        }
    }

    @Override
    @WebRemote
    public String pasteWithId(String docId) {
        try {
            String debug = "pasting " + docId;
            log.debug((Object)debug);
            if (docId.startsWith("pasteRef_")) {
                docId = docId.split("pasteRef_")[1];
            }
            if (docId.startsWith("docClipboardRef:")) {
                docId = docId.split("docClipboardRef:")[1];
            }
            IdRef srcRef = new IdRef(docId);
            DocumentModel srcDoc = this.documentManager.getDocument((DocumentRef)srcRef);
            ArrayList<DocumentModel> pasteDocs = new ArrayList<DocumentModel>();
            pasteDocs.add(srcDoc);
            this.clipboardActions.pasteDocumentList(pasteDocs);
            return debug;
        }
        catch (RecoverableClientException e) {
            throw e;
        }
        catch (NuxeoException e) {
            throw new RecoverableClientException("Cannot validate, caught exception", "message.operation.fails.generic", null, (Throwable)e);
        }
    }

    public void processUpload(FileUploadEvent uploadEvent) {
        try {
            if (this.fileUploadHolder != null) {
                FileBlob blob = FileManageActionsBean.getBlob(uploadEvent);
                this.tmpFilePaths.add(blob.getFile().getPath());
                this.fileUploadHolder.getUploadedFiles().add(new NxUploadedFile((Blob)blob));
            } else {
                log.error((Object)"Unable to reach fileUploadHolder");
            }
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    protected static String getJSFUploadTmpDirPath() {
        String jstTmpFileDir = Framework.getProperty((String)"nuxeo.jsf.tmp.dir");
        if (StringUtils.isBlank((CharSequence)jstTmpFileDir)) {
            jstTmpFileDir = null;
        }
        return jstTmpFileDir;
    }

    public static FileBlob getBlob(FileUploadEvent uploadEvent) throws IOException {
        String jstTmpFileDir = FileManageActionsBean.getJSFUploadTmpDirPath();
        File tmpDir = null;
        if (jstTmpFileDir != null) {
            tmpDir = new File(jstTmpFileDir);
        }
        UploadedFile uploadedFile = uploadEvent.getUploadedFile();
        try (InputStream in = uploadedFile.getInputStream();){
            FileBlob blob = new FileBlob(in, uploadedFile.getContentType(), null, tmpDir);
            blob.setFilename(FileUtils.getCleanFileName((String)uploadedFile.getName()));
            FileBlob fileBlob = blob;
            return fileBlob;
        }
    }

    public void validateMultiplesUpload() throws FileNotFoundException, IOException {
        DocumentModel current = this.navigationContext.getCurrentDocument();
        this.validateMultipleUploadForDocument(current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateMultipleUploadForDocument(DocumentModel current) throws FileNotFoundException, IOException {
        if (!current.hasSchema(FILES_SCHEMA)) {
            return;
        }
        Collection<NxUploadedFile> nxuploadFiles = this.getUploadedFiles();
        try {
            ArrayList files = (ArrayList)current.getPropertyValue(FILES_PROPERTY);
            if (nxuploadFiles != null) {
                for (NxUploadedFile uploadItem : nxuploadFiles) {
                    Blob blob = uploadItem.getBlob();
                    FileUtils.configureFileBlob((Blob)blob);
                    HashMap<String, Blob> fileMap = new HashMap<String, Blob>(1);
                    fileMap.put("file", blob);
                    if (files.contains(fileMap)) continue;
                    files.add(fileMap);
                }
            }
            current.setPropertyValue(FILES_PROPERTY, (Serializable)files);
            this.documentActions.updateDocument(current, Boolean.TRUE);
        }
        finally {
            if (nxuploadFiles != null) {
                for (NxUploadedFile uploadItem : nxuploadFiles) {
                    File tempFile = uploadItem.getFile();
                    if (tempFile == null || !tempFile.exists() || !this.tmpFilePaths.contains(tempFile.getPath())) continue;
                    Framework.trackFile((File)tempFile, (Object)tempFile);
                }
            }
            this.tmpFilePaths.clear();
        }
    }

    public void performAction(ActionEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext eContext = context.getExternalContext();
        String index = (String)eContext.getRequestParameterMap().get("index");
        try {
            DocumentModel current = this.navigationContext.getCurrentDocument();
            if (!current.hasSchema(FILES_SCHEMA)) {
                return;
            }
            ArrayList files = (ArrayList)current.getPropertyValue(FILES_PROPERTY);
            Object file = CollectionUtils.get((Object)files, (int)Integer.valueOf(index));
            files.remove(file);
            current.setPropertyValue(FILES_PROPERTY, (Serializable)files);
            this.documentActions.updateDocument(current, Boolean.TRUE);
        }
        catch (IndexOutOfBoundsException | NuxeoException e) {
            log.error((Object)e, e);
            throw e;
        }
    }

    public String validate() {
        NxUploadedFile uploadedFile;
        if (this.fileUploadHolder == null || this.fileUploadHolder.getUploadedFiles().isEmpty() || (uploadedFile = this.fileUploadHolder.getUploadedFiles().iterator().next()) == null) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("fileImporter.error.nullUploadedFile"), new Object[0]);
            return null;
        }
        try {
            String string = this.addFile();
            return string;
        }
        catch (RecoverableClientException e) {
            throw e;
        }
        catch (NuxeoException e) {
            throw new RecoverableClientException("Cannot validate, caught exception", "message.operation.fails.generic", null, (Throwable)e);
        }
        finally {
            if (uploadedFile != null && uploadedFile.getFile().exists()) {
                Framework.trackFile((File)uploadedFile.getFile(), (Object)uploadedFile.getFile());
            }
        }
    }

    @Override
    public InputStream getFileUpload() {
        if (this.fileUploadHolder != null) {
            return this.fileUploadHolder.getFileUpload();
        }
        return null;
    }

    @Override
    public void setFileUpload(InputStream fileUpload) {
        if (this.fileUploadHolder != null) {
            this.fileUploadHolder.setFileUpload(fileUpload);
        }
    }

    @Override
    public String getFileName() {
        if (this.fileUploadHolder != null) {
            return this.fileUploadHolder.getFileName();
        }
        return null;
    }

    @Override
    public void setFileName(String fileName) {
        if (this.fileUploadHolder != null) {
            this.fileUploadHolder.setFileName(fileName);
        }
    }

    public DocumentModel getChangeableDocument() {
        return this.navigationContext.getChangeableDocument();
    }

    public void setChangeableDocument(DocumentModel changeableDocument) {
        this.navigationContext.setChangeableDocument(changeableDocument);
    }

    public Collection<NxUploadedFile> getUploadedFiles() {
        if (this.fileUploadHolder != null) {
            return this.fileUploadHolder.getUploadedFiles();
        }
        return null;
    }

    public void setUploadedFiles(Collection<NxUploadedFile> uploadedFiles) {
        if (this.fileUploadHolder != null) {
            this.fileUploadHolder.setUploadedFiles(uploadedFiles);
        }
        this.tmpFilePaths.clear();
        if (uploadedFiles != null) {
            for (NxUploadedFile file : uploadedFiles) {
                this.tmpFilePaths.add(file.getFile().getPath());
            }
        }
    }

    @Override
    @WebRemote
    public String removeSingleUploadedFile() {
        return this.removeAllUploadedFile();
    }

    @Override
    public void setFileToRemove(String fileToRemove) {
        this.fileToRemove = fileToRemove;
    }

    @Override
    public String removeOneOrAllUploadedFiles(ActionEvent action) {
        if (StringUtils.isBlank((CharSequence)this.fileToRemove)) {
            return this.removeAllUploadedFile();
        }
        return this.removeUploadedFile(this.fileToRemove);
    }

    @Override
    @WebRemote
    public String removeAllUploadedFile() {
        if (this.fileUploadHolder != null) {
            Collection<NxUploadedFile> files = this.getUploadedFiles();
            if (files != null) {
                for (NxUploadedFile item : files) {
                    item.getFile().delete();
                }
            }
            this.setUploadedFiles(new ArrayList<NxUploadedFile>());
        }
        return "";
    }

    @Override
    @WebRemote
    public String removeUploadedFile(String fileName) {
        NxUploadedFile fileToDelete = null;
        fileName = FilenameUtils.getName((String)fileName);
        Collection<NxUploadedFile> files = this.getUploadedFiles();
        if (files != null) {
            for (NxUploadedFile file : files) {
                String uploadedFileName = file.getName();
                if (!fileName.equals(uploadedFileName)) continue;
                fileToDelete = file;
                break;
            }
        }
        if (fileToDelete != null) {
            fileToDelete.getFile().delete();
            files.remove(fileToDelete);
            this.setUploadedFiles(files);
        }
        return "";
    }
}

