/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.directory;

import java.util.ArrayList;
import java.util.HashMap;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionPropertiesDescriptor;

@XObject(value="directoryTree")
public class DirectoryTreeDescriptor {
    public static final String ACTION_ID_PREFIX = "dirtree_";
    public static final String NAV_ACTION_CATEGORY = "TREE_EXPLORER";
    public static final String DIR_ACTION_CATEGORY = "DIRECTORY_TREE_EXPLORER";
    @XNode(value="@name")
    protected String name;
    @XNode(value="@enabled")
    protected Boolean enabled = true;
    @XNode(value="@isNavigationTree")
    protected boolean isNavigationTree = true;
    @XNode(value="@label")
    protected String label;
    @XNode(value="@contentView")
    protected String contentView;
    @XNode(value="@field")
    protected String fieldName;
    @XNode(value="@schema")
    protected String schemaName;
    @XNode(value="@outcome")
    protected String outcome;
    @XNode(value="@multiselect")
    protected Boolean multiselect;
    protected String[] directories;
    @XNode(value="@order")
    protected Integer order;

    @XNodeList(value="directory", componentType=String.class, type=String[].class)
    public void setDirectories(String[] directories) {
        this.directories = directories;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getName() {
        return this.name;
    }

    public String[] getDirectories() {
        return this.directories;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isMultiselect() {
        if (this.multiselect == null) {
            return false;
        }
        return this.multiselect;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public String getContentView() {
        return this.contentView;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public boolean isNavigationTree() {
        return this.isNavigationTree;
    }

    public boolean hasContentViewSupport() {
        return this.contentView != null;
    }

    public Integer getOrder() {
        return this.order;
    }

    public void merge(DirectoryTreeDescriptor other) {
        if (other.schemaName != null) {
            this.schemaName = other.schemaName;
        }
        if (other.contentView != null) {
            this.contentView = other.contentView;
        }
        if (other.outcome != null) {
            this.outcome = other.outcome;
        }
        if (other.multiselect != null) {
            this.multiselect = other.multiselect;
        }
        if (other.label != null) {
            this.label = other.label;
        }
        if (other.directories != null) {
            this.directories = other.directories;
        }
        if (other.fieldName != null) {
            this.fieldName = other.fieldName;
        }
        this.enabled = other.enabled;
        this.isNavigationTree = other.isNavigationTree;
        if (other.order != null) {
            this.order = other.order;
        }
    }

    public DirectoryTreeDescriptor clone() {
        DirectoryTreeDescriptor clone = new DirectoryTreeDescriptor();
        clone.name = this.name;
        clone.enabled = this.enabled;
        clone.isNavigationTree = this.isNavigationTree;
        clone.label = this.label;
        clone.contentView = this.contentView;
        clone.fieldName = this.fieldName;
        clone.schemaName = this.schemaName;
        clone.outcome = this.outcome;
        clone.multiselect = this.multiselect;
        if (this.directories != null) {
            clone.directories = (String[])this.directories.clone();
        }
        clone.order = this.order;
        return clone;
    }

    protected Action getAction() {
        String[] cats = this.isNavigationTree() ? new String[]{NAV_ACTION_CATEGORY, DIR_ACTION_CATEGORY} : new String[]{DIR_ACTION_CATEGORY};
        Action a = new Action(ACTION_ID_PREFIX + this.getName(), cats);
        a.setType("rest_document_link");
        a.setLabel(this.getLabel());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("ajaxSupport", "true");
        props.put("link", "/incl/single_directory_tree_explorer.xhtml");
        ActionPropertiesDescriptor pdesc = new ActionPropertiesDescriptor();
        pdesc.setProperties(props);
        a.setPropertiesDescriptor(pdesc);
        Integer order = this.getOrder();
        if (order != null) {
            a.setOrder(order.intValue());
        } else {
            a.setOrder(1000);
        }
        a.setIcon("/img/" + this.getName() + ".png");
        a.setEnabled(Boolean.TRUE.equals(this.getEnabled()));
        a.setFilterIds(new ArrayList());
        return a;
    }
}

