/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.io.client;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.impl.DocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveWriter;
import org.nuxeo.ecm.platform.io.selectionReader.DocumentModelListReader;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.webapp.clipboard.ClipboardActions;

@Name(value="importExportAction")
@Scope(value=ScopeType.EVENT)
public class ImportExportActionBean
implements Serializable {
    private static final String RESTLET_PREFIX = "restAPI";
    private static final Log log = LogFactory.getLog(ImportExportActionBean.class);
    private static final long serialVersionUID = 1770386525984671333L;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient ClipboardActions clipboardActions;

    private static StringBuilder getRestletBaseURL(DocumentModel doc) {
        StringBuilder urlb = new StringBuilder();
        urlb.append(BaseURL.getBaseURL());
        urlb.append(RESTLET_PREFIX);
        urlb.append('/');
        urlb.append(doc.getRepositoryName());
        urlb.append('/');
        urlb.append(doc.getRef().toString());
        urlb.append('/');
        return urlb;
    }

    private static HttpServletResponse getHttpServletResponse() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext == null ? null : (HttpServletResponse)facesContext.getExternalContext().getResponse();
    }

    private static HttpServletRequest getHttpServletRequest() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return (HttpServletRequest)facesContext.getExternalContext().getRequest();
    }

    private static void handleRedirect(HttpServletResponse response, String url) throws IOException {
        response.resetBuffer();
        response.sendRedirect(url);
        response.flushBuffer();
        ImportExportActionBean.getHttpServletRequest().setAttribute("nuxeo.disable.redirect.wrapper", (Object)true);
        FacesContext.getCurrentInstance().responseComplete();
    }

    public String doExportDocument() throws IOException {
        HttpServletResponse response = ImportExportActionBean.getHttpServletResponse();
        if (response != null) {
            ImportExportActionBean.handleRedirect(response, this.getDocumentExportURL());
        }
        return null;
    }

    public String doExportFolder() throws IOException {
        HttpServletResponse response = ImportExportActionBean.getHttpServletResponse();
        if (response != null) {
            ImportExportActionBean.handleRedirect(response, this.getFolderExportURL());
        }
        return null;
    }

    public String getExportURL(DocumentModel doc, boolean exportAsZip, boolean exportAsTree) {
        if (doc == null) {
            return null;
        }
        StringBuilder urlb = ImportExportActionBean.getRestletBaseURL(doc);
        if (exportAsTree) {
            urlb.append("exportTree");
        } else if (exportAsZip) {
            urlb.append("export?format=ZIP");
        } else {
            urlb.append("export?format=XML");
        }
        return urlb.toString();
    }

    public String getDocumentExportURL() {
        return this.getExportURL(this.navigationContext.getCurrentDocument(), true, true);
    }

    public String getFolderExportURL() {
        return this.getExportURL(this.navigationContext.getCurrentDocument(), true, true);
    }

    public String getDocumentXMLExportURL() {
        return this.getExportURL(this.navigationContext.getCurrentDocument(), false, false);
    }

    public String getDocumentZIPExportURL() {
        return this.getExportURL(this.navigationContext.getCurrentDocument(), true, false);
    }

    public String getDocumentZIPTreeExportURL() {
        return this.getExportURL(this.navigationContext.getCurrentDocument(), true, true);
    }

    public String exportCurrentList() {
        List docList = this.clipboardActions.getCurrentSelectedList();
        if (docList != null) {
            ImportExportActionBean.export(docList);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void export(List<DocumentModel> docList) {
        DocumentModelListReader reader = null;
        NuxeoArchiveWriter writer = null;
        Blob blob = null;
        try {
            reader = new DocumentModelListReader(docList);
            blob = Blobs.createBlobWithExtension((String)"zip");
            writer = new NuxeoArchiveWriter(blob.getFile());
            DocumentPipeImpl pipe = new DocumentPipeImpl(10);
            pipe.setReader((DocumentReader)reader);
            pipe.setWriter((DocumentWriter)writer);
            pipe.run();
        }
        catch (IOException e) {
            log.error((Object)("Error during XML export " + e.getMessage()));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        if (blob != null) {
            ComponentUtils.download(null, null, (Blob)blob, (String)"export.zip", (String)"workListXML");
            if (blob.getFile() != null) {
                blob.getFile().delete();
            }
        }
    }
}

