/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jsf.operations;

import org.jboss.seam.contexts.Contexts;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="Seam.PushDocument", category="User Interface", requires="Seam", label="Push to Seam Context", description="Push the current input document into Seam context. Returns back the document.", aliases={"WebUI.PushDocumentToSeamContext"})
public class PushToSeamContext {
    public static final String ID = "Seam.PushDocument";
    @Context
    protected OperationContext ctx;
    @Param(name="name")
    protected String name;
    @Param(name="scope", widget="Option", values={"session", "conversation", "page", "event"})
    protected String scope;

    @OperationMethod
    public DocumentModel push(DocumentModel value) {
        if ("session".equalsIgnoreCase(this.scope)) {
            Contexts.getSessionContext().set(this.name, (Object)value);
        } else if ("conversation".equalsIgnoreCase(this.scope)) {
            Contexts.getConversationContext().set(this.name, (Object)value);
        } else if ("page".equalsIgnoreCase(this.scope)) {
            Contexts.getPageContext().set(this.name, (Object)value);
        } else if ("event".equalsIgnoreCase(this.scope)) {
            Contexts.getEventContext().set(this.name, (Object)value);
        }
        return value;
    }
}

