/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.http.entity.ContentType;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.restlet.Request;
import org.restlet.engine.adapter.HttpRequest;
import org.restlet.engine.adapter.ServerCall;
import org.restlet.ext.servlet.internal.ServletCall;

public class FileUploadHelper {
    private FileUploadHelper() {
    }

    public static List<Blob> parseRequest(Request request) throws FileUploadException, IOException {
        HttpRequest httpRequest;
        ServerCall httpCall;
        if (request instanceof HttpRequest && (httpCall = (httpRequest = (HttpRequest)request).getHttpCall()) instanceof ServletCall) {
            HttpServletRequest httpServletRequest = ((ServletCall)httpCall).getRequest();
            return FileUploadHelper.parseRequest(httpServletRequest);
        }
        return null;
    }

    public static List<Blob> parseRequest(HttpServletRequest request) throws FileUploadException, IOException {
        if (!FileUploadHelper.isMultipartRequest(request)) {
            try (ServletInputStream in = request.getInputStream();){
                Blob blob = FileUploadHelper.createBlob((InputStream)in, request.getContentType());
                List<Blob> list = Collections.singletonList(blob);
                return list;
            }
        }
        FileUpload fileUpload = new FileUpload((FileItemFactory)new DiskFileItemFactory());
        String fileNameCharset = request.getHeader("FileNameCharset");
        if (fileNameCharset != null) {
            fileUpload.setHeaderEncoding(fileNameCharset);
        }
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        for (FileItem item : fileUpload.parseRequest((RequestContext)new ServletRequestContext(request))) {
            InputStream is = item.getInputStream();
            Throwable throwable = null;
            try {
                Blob blob = FileUploadHelper.createBlob(is, item.getContentType());
                blob.setFilename(item.getName());
                blobs.add(blob);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
        return blobs;
    }

    public static boolean isMultipartRequest(Request request) {
        HttpServletRequest httpServletRequest = ((ServletCall)((HttpRequest)request).getHttpCall()).getRequest();
        return FileUploadHelper.isMultipartRequest(httpServletRequest);
    }

    public static boolean isMultipartRequest(HttpServletRequest request) {
        if (!"POST".equalsIgnoreCase(request.getMethod())) {
            return false;
        }
        String contentType = request.getContentType();
        return contentType == null ? false : contentType.toLowerCase().startsWith("multipart/");
    }

    public static Blob createBlob(InputStream in, String contentType) throws IOException {
        ContentType ct = ContentType.parse((String)contentType);
        String mimeType = ct.getMimeType();
        Charset charset = ct.getCharset();
        String encoding = charset == null ? null : charset.name();
        return Blobs.createBlob((InputStream)in, (String)mimeType, (String)encoding);
    }
}

