/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jsf.operations;

import java.io.IOException;
import java.util.Collections;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Seam.DownloadFile", category="User Interface", requires="Seam", label="Download file", description="Download a file", aliases={"WebUI.DownloadFile"})
public class DownloadFile {
    protected static Log log = LogFactory.getLog(DownloadFile.class);
    public static final String ID = "Seam.DownloadFile";
    @Context
    protected OperationContext ctx;

    @OperationMethod
    public void run(Blob blob) throws OperationException, IOException {
        if (blob == null) {
            throw new OperationException("there is no file content available");
        }
        DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
        String key = downloadService.storeBlobs(Collections.singletonList(blob));
        String url = BaseURL.getBaseURL() + downloadService.getDownloadUrl(key);
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        HttpServletRequest request = (HttpServletRequest)externalContext.getRequest();
        HttpServletResponse response = (HttpServletResponse)externalContext.getResponse();
        try {
            request.setAttribute("nuxeo.disable.redirect.wrapper", (Object)new Boolean(true));
            externalContext.redirect(url);
            response.flushBuffer();
            FacesContext.getCurrentInstance().responseComplete();
            this.ctx.getVars().put("Outcome", null);
        }
        catch (IOException e) {
            log.error((Object)"Error while redirecting for big blob downloader", (Throwable)e);
        }
    }
}

