/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.resources;

import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.web.resources.api.ResourceType;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class NuxeoWebResourceDispatcher
implements ComponentSystemEventListener {
    private static final Log log = LogFactory.getLog(NuxeoWebResourceDispatcher.class);
    protected static String TARGET_HEAD = "head";
    protected static String SLOT_HEAD_START = "headstart";
    private static String SLOT_BODY_START = "bodystart";
    private static String SLOT_BODY_END = "bodyend";
    private static String DEFER_JS_PROP = "nuxeo.jsf.deferJavaScriptLoading";

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        FacesContext ctx = FacesContext.getCurrentInstance();
        UIViewRoot root = ctx.getViewRoot();
        boolean ajaxRequest = ctx.getPartialViewContext().isAjaxRequest();
        if (ajaxRequest) {
            List resources = root.getComponentResources(ctx, TARGET_HEAD);
            String message = "Head resource %s on ajax request";
            for (UIComponent r : resources) {
                this.logResourceInfo(r, message);
            }
            return;
        }
        ArrayList<UIComponent> cssResources = new ArrayList<UIComponent>();
        ArrayList<UIComponent> otherResources = new ArrayList<UIComponent>();
        List resources = root.getComponentResources(ctx, TARGET_HEAD);
        for (UIComponent r : resources) {
            if (this.isCssResource(ctx, r)) {
                cssResources.add(r);
                continue;
            }
            otherResources.add(r);
        }
        this.moveResources(ctx, root, cssResources, TARGET_HEAD, SLOT_HEAD_START, "Pushing head resource %s at the beggining of head tag");
        if (this.isDeferJavaScriptLoading()) {
            this.moveResources(ctx, root, otherResources, TARGET_HEAD, SLOT_BODY_START, "Pushing head resource %s at the beggining of body tag");
        }
    }

    protected void moveResources(FacesContext ctx, UIViewRoot root, List<UIComponent> resources, String removeFrom, String addTo, String message) {
        ArrayList existing = new ArrayList(root.getComponentResources(ctx, addTo));
        for (UIComponent r : resources) {
            ComponentUtils.setRelocated((UIComponent)r);
            root.removeComponentResource(ctx, r, removeFrom);
            root.addComponentResource(ctx, r, addTo);
            this.logResourceInfo(r, message);
        }
        for (UIComponent r : existing) {
            root.addComponentResource(ctx, r, addTo);
        }
    }

    protected void logResourceInfo(UIComponent resource, String message) {
        if (log.isDebugEnabled()) {
            String name = this.getLogName(resource);
            if (StringUtils.isBlank((CharSequence)name)) {
                log.debug((Object)String.format(message, resource));
            } else {
                log.debug((Object)String.format(message, name));
            }
        }
    }

    protected String getLogName(UIComponent resource) {
        String name = (String)resource.getAttributes().get("name");
        if (StringUtils.isBlank((CharSequence)name)) {
            return (String)resource.getAttributes().get("src");
        }
        return name;
    }

    protected boolean isCssResource(FacesContext ctx, UIComponent r) {
        String rtype = r.getRendererType();
        if ("javax.faces.resource.Stylesheet".equals(rtype)) {
            return true;
        }
        if ("org.nuxeo.ecm.web.resources.jsf.ResourceBundle".equals(rtype) || "org.nuxeo.ecm.web.resources.jsf.PageResource".equals(rtype)) {
            String type = (String)r.getAttributes().get("type");
            return ResourceType.css.equals(type) || ResourceType.jsfcss.equals(type);
        }
        String name = (String)r.getAttributes().get("name");
        if (name == null) {
            return false;
        }
        return (name = name.toLowerCase()).contains(".css") || name.contains(".ecss");
    }

    public boolean isDeferJavaScriptLoading() {
        ConfigurationService cs = (ConfigurationService)Framework.getService(ConfigurationService.class);
        return cs.isBooleanPropertyTrue(DEFER_JS_PROP);
    }

    public String getHeadStartTarget() {
        return SLOT_HEAD_START;
    }

    public String getBodyStartTarget() {
        return SLOT_BODY_START;
    }

    public String getBodyEndTarget() {
        return SLOT_BODY_END;
    }

    public String getHeadJavaScriptTarget() {
        return this.isDeferJavaScriptLoading() ? SLOT_BODY_END : SLOT_BODY_START;
    }

    public String getBodyJavaScriptTarget() {
        return this.isDeferJavaScriptLoading() ? SLOT_BODY_END : null;
    }
}

