/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.security;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.common.utils.UserAgentMatcher;
import org.nuxeo.common.utils.i18n.Labeler;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.PermissionProvider;
import org.nuxeo.ecm.core.api.security.UserEntry;
import org.nuxeo.ecm.core.api.security.UserVisiblePermission;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.platform.query.api.PageSelection;
import org.nuxeo.ecm.platform.query.api.PageSelections;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.security.PermissionActionListManager;
import org.nuxeo.ecm.webapp.security.PermissionListManager;
import org.nuxeo.ecm.webapp.security.PrincipalListManager;
import org.nuxeo.ecm.webapp.security.SecurityActions;
import org.nuxeo.ecm.webapp.security.SecurityData;
import org.nuxeo.ecm.webapp.security.SecurityDataConverter;
import org.nuxeo.ecm.webapp.security.UIPermissionService;
import org.nuxeo.runtime.api.Framework;

@Name(value="securityActions")
@Scope(value=ScopeType.CONVERSATION)
public class SecurityActionsBean
extends InputController
implements SecurityActions,
Serializable {
    private static final long serialVersionUID = -7190826911734958662L;
    private static final Log log = LogFactory.getLog(SecurityActionsBean.class);
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected PermissionActionListManager permissionActionListManager;
    @In(create=true)
    protected PermissionListManager permissionListManager;
    @In(create=true)
    protected PrincipalListManager principalListManager;
    @In(create=true)
    protected transient UserManager userManager;
    @In(create=true)
    protected NuxeoPrincipal currentUser;
    protected static final String[] SEED_PERMISSIONS_TO_CHECK = new String[]{"WriteSecurity", "ReadSecurity"};
    private static final Labeler labeler = new Labeler("label.security.permission");
    protected String[] CACHED_PERMISSION_TO_CHECK;
    protected SecurityData securityData;
    protected boolean obsoleteSecurityData = true;
    protected PageSelections<String> entries;
    protected transient List<String> cachedValidatedUserAndGroups;
    protected transient List<String> cachedDeletedUserAndGroups;
    private Boolean blockRightInheritance;
    protected String selectedEntry;
    protected List<String> selectedEntries;

    @Override
    @Observer(value={"userAllDocumentTypesSelectionChanged"}, create=false)
    @BypassInterceptors
    public void resetSecurityData() {
        this.obsoleteSecurityData = true;
        this.blockRightInheritance = null;
    }

    @Override
    public void rebuildSecurityData() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument != null) {
            ACP acp;
            if (this.securityData == null) {
                this.securityData = new SecurityData();
                this.securityData.setDocumentType(currentDocument.getType());
            }
            if ((acp = this.documentManager.getACP(currentDocument.getRef())) != null) {
                SecurityDataConverter.convertToSecurityData(acp, this.securityData);
            } else {
                this.securityData.clear();
            }
            this.reconstructTableModel();
            List<String> deniedPerms = this.securityData.getCurrentDocDeny().get("Everyone");
            if (deniedPerms != null && deniedPerms.contains("Everything")) {
                this.blockRightInheritance = Boolean.TRUE;
            }
            if (this.blockRightInheritance == null) {
                this.blockRightInheritance = Boolean.FALSE;
            }
            this.obsoleteSecurityData = false;
        }
    }

    protected void reconstructTableModel() {
        List<String> items = this.getCurrentDocumentUsers();
        this.entries = new PageSelections();
        if (items != null) {
            for (String item : items) {
                if ("Everyone".equals(item)) {
                    List<String> grantedPerms = this.securityData.getCurrentDocGrant().get(item);
                    List<String> deniedPerms = this.securityData.getCurrentDocDeny().get(item);
                    if (deniedPerms != null && deniedPerms.contains("Everything") && grantedPerms == null && deniedPerms.size() == 1) continue;
                }
                this.entries.add(new PageSelection((Object)item, false));
            }
        }
    }

    @Override
    public PageSelections<String> getDataTableModel() {
        if (this.obsoleteSecurityData) {
            this.rebuildSecurityData();
        }
        return this.entries;
    }

    @Override
    public SecurityData getSecurityData() {
        if (this.obsoleteSecurityData) {
            this.rebuildSecurityData();
        }
        return this.securityData;
    }

    @Override
    public String updateSecurityOnDocument() {
        List<UserEntry> modifiableEntries = SecurityDataConverter.convertToUserEntries(this.securityData);
        ACP acp = this.currentDocument.getACP();
        if (acp == null) {
            acp = new ACPImpl();
        }
        acp.setRules(modifiableEntries.toArray(new UserEntry[0]));
        this.currentDocument.setACP(acp, true);
        this.documentManager.save();
        Events.instance().raiseEvent("documentSecurityChanged", new Object[0]);
        this.rebuildSecurityData();
        return null;
    }

    @Override
    public String addPermission(String principalName, String permissionName, boolean grant) {
        if (this.securityData == null) {
            this.securityData = this.getSecurityData();
        }
        String grantPerm = permissionName;
        String denyPerm = permissionName;
        List<UserVisiblePermission> uvps = this.getVisibleUserPermissions(this.securityData.getDocumentType());
        if (uvps != null) {
            for (UserVisiblePermission uvp : uvps) {
                if (!uvp.getId().equals(permissionName)) continue;
                grantPerm = uvp.getPermission();
                denyPerm = uvp.getDenyPermission();
                break;
            }
        } else {
            log.debug((Object)"no entry for documentType in visibleUserPermissions this should never happend, using default mapping ...");
        }
        if (grant) {
            boolean removed = this.securityData.removeModifiablePrivilege(principalName, denyPerm, !grant);
            if (!removed) {
                removed = this.securityData.removeModifiablePrivilege(principalName, grantPerm, !grant);
            }
            if (!removed) {
                this.securityData.addModifiablePrivilege(principalName, grantPerm, grant);
            }
        } else {
            boolean removed = this.securityData.removeModifiablePrivilege(principalName, grantPerm, !grant);
            if (!removed) {
                removed = this.securityData.removeModifiablePrivilege(principalName, denyPerm, !grant);
            }
            if (!removed) {
                this.securityData.addModifiablePrivilege(principalName, denyPerm, grant);
            }
        }
        this.reconstructTableModel();
        return null;
    }

    @Override
    public String addPermission() {
        String permissionName = this.permissionListManager.getSelectedPermission();
        boolean grant = this.permissionActionListManager.getSelectedGrant().equals("Grant");
        return this.addPermission(this.selectedEntry, permissionName, grant);
    }

    @Override
    public String addPermissions() {
        if (this.selectedEntries == null || this.selectedEntries.isEmpty()) {
            String message = ComponentUtils.translate((FacesContext)FacesContext.getCurrentInstance(), (String)"error.rightsManager.noUsersSelected");
            FacesMessages.instance().add(message, new Object[0]);
            return null;
        }
        String permissionName = this.permissionListManager.getSelectedPermission();
        boolean grant = this.permissionActionListManager.getSelectedGrant().equals("Grant");
        for (String principalName : this.selectedEntries) {
            this.addPermission(principalName, permissionName, grant);
        }
        return null;
    }

    @Override
    public String addPermissionAndUpdate() {
        this.addPermission();
        this.updateSecurityOnDocument();
        return null;
    }

    @Override
    public String addPermissionsAndUpdate() {
        this.addPermissions();
        this.updateSecurityOnDocument();
        this.selectedEntries = null;
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("message.updated.rights"), new Object[0]);
        return null;
    }

    @Override
    public String saveSecurityUpdates() {
        this.updateSecurityOnDocument();
        this.selectedEntries = null;
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("message.updated.rights"), new Object[0]);
        return null;
    }

    @Override
    public String removePermission() {
        this.securityData.removeModifiablePrivilege(this.selectedEntry, this.permissionListManager.getSelectedPermission(), this.permissionActionListManager.getSelectedGrant().equals("Grant"));
        this.reconstructTableModel();
        return null;
    }

    @Override
    public String removePermissionAndUpdate() {
        this.removePermission();
        if (!this.checkPermissions()) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("message.updated.rights"), new Object[0]);
            return null;
        }
        this.updateSecurityOnDocument();
        return null;
    }

    @Override
    public String removePermissions() {
        for (PageSelection<String> user : this.getSelectedRows()) {
            this.securityData.removeModifiablePrivilege((String)user.getData());
            if (this.checkPermissions()) continue;
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("message.error.removeRight"), new Object[0]);
            return null;
        }
        this.reconstructTableModel();
        return null;
    }

    @Override
    public String removePermissionsAndUpdate() {
        for (PageSelection user : this.getDataTableModel().getEntries()) {
            this.securityData.removeModifiablePrivilege((String)user.getData());
            if (this.checkPermissions()) continue;
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("message.error.removeRight"), new Object[0]);
            return null;
        }
        this.updateSecurityOnDocument();
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("message.updated.rights"), new Object[0]);
        return null;
    }

    @Override
    public boolean getCanAddSecurityRules() {
        return this.documentManager.hasPermission(this.currentDocument.getRef(), "WriteSecurity");
    }

    @Override
    public boolean getCanRemoveSecurityRules() {
        return this.documentManager.hasPermission(this.currentDocument.getRef(), "WriteSecurity") && !this.getSelectedRows().isEmpty();
    }

    private List<PageSelection<String>> getSelectedRows() {
        ArrayList<PageSelection<String>> selectedRows = new ArrayList<PageSelection<String>>();
        if (!this.getDataTableModel().isEmpty()) {
            for (PageSelection entry : this.getDataTableModel().getEntries()) {
                if (!entry.isSelected()) continue;
                selectedRows.add((PageSelection<String>)entry);
            }
        }
        return selectedRows;
    }

    public List<UserVisiblePermission> getVisibleUserPermissions(String documentType) {
        return ((PermissionProvider)Framework.getService(PermissionProvider.class)).getUserVisiblePermissionDescriptors(documentType);
    }

    @Override
    public List<SelectItem> getSettablePermissions() {
        String documentType = this.navigationContext.getCurrentDocument().getType();
        UIPermissionService service = (UIPermissionService)((Object)Framework.getRuntime().getComponent("org.nuxeo.ecm.webapp.security.UIPermissionService"));
        String[] settablePermissions = service.getUIPermissions(documentType);
        if (settablePermissions == null || settablePermissions.length == 0) {
            List<UserVisiblePermission> visiblePerms = this.getVisibleUserPermissions(documentType);
            settablePermissions = new String[visiblePerms.size()];
            int idx = 0;
            for (UserVisiblePermission uvp : visiblePerms) {
                settablePermissions[idx] = uvp.getId();
                ++idx;
            }
        }
        return this.asSelectItems(settablePermissions);
    }

    protected List<SelectItem> asSelectItems(String ... permissions) {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (String perm : permissions) {
            String label = labeler.makeLabel(perm);
            SelectItem it = new SelectItem((Object)perm, (String)this.resourcesAccessor.getMessages().get(label));
            items.add(it);
        }
        return items;
    }

    public List<SelectItem> getUserVisiblePermissionSelectItems(String documentType) {
        List<UserVisiblePermission> userVisiblePermissions = this.getVisibleUserPermissions(documentType);
        ArrayList<String> permissions = new ArrayList<String>();
        for (UserVisiblePermission userVisiblePermission : userVisiblePermissions) {
            permissions.add(userVisiblePermission.getId());
        }
        return this.asSelectItems(permissions.toArray(new String[permissions.size()]));
    }

    @Override
    public Map<String, String> getIconAltMap() {
        return this.principalListManager.iconAlt;
    }

    @Override
    public Map<String, String> getIconPathMap() {
        return this.principalListManager.iconPath;
    }

    @Override
    public Boolean getBlockRightInheritance() {
        return this.blockRightInheritance;
    }

    @Override
    public void setBlockRightInheritance(Boolean blockRightInheritance) {
        this.blockRightInheritance = blockRightInheritance;
    }

    public String blockRightInheritance() {
        Boolean needBlockRightInheritance = this.blockRightInheritance;
        if (needBlockRightInheritance.booleanValue()) {
            this.securityData.addModifiablePrivilege("Everyone", "Everything", false);
            Principal currentUser = FacesContext.getCurrentInstance().getExternalContext().getUserPrincipal();
            if (this.securityData.getCurrentDocumentUsers() != null && !this.securityData.getCurrentDocumentUsers().contains(currentUser.getName())) {
                this.securityData.addModifiablePrivilege(currentUser.getName(), "Everything", true);
                List adminGroups = this.userManager.getAdministratorsGroups();
                for (String adminGroup : adminGroups) {
                    this.securityData.addModifiablePrivilege(adminGroup, "Everything", true);
                }
            }
        } else {
            this.securityData.removeModifiablePrivilege("Everyone", "Everything", false);
        }
        this.updateSecurityOnDocument();
        this.selectedEntries = null;
        return null;
    }

    @Override
    public Boolean displayInheritedPermissions() {
        return this.getDisplayInheritedPermissions();
    }

    @Override
    public boolean getDisplayInheritedPermissions() {
        if (this.blockRightInheritance == null) {
            this.rebuildSecurityData();
        }
        if (this.blockRightInheritance.booleanValue()) {
            return false;
        }
        return !this.securityData.getParentDocumentsUsers().isEmpty();
    }

    @Override
    public List<String> getCurrentDocumentUsers() {
        List<String> currentUsers = this.securityData.getCurrentDocumentUsers();
        return this.validateUserGroupList(currentUsers);
    }

    @Override
    public List<String> getParentDocumentsUsers() {
        List<String> parentUsers = this.securityData.getParentDocumentsUsers();
        return this.validateUserGroupList(parentUsers);
    }

    private List<String> validateUserGroupList(List<String> usersGroups2Validate) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (String entry : usersGroups2Validate) {
            if (entry.equals("Everyone")) {
                returnList.add(entry);
                continue;
            }
            if (this.isUserGroupInCache(entry).booleanValue()) {
                returnList.add(entry);
                continue;
            }
            if (this.isUserGroupInDeletedCache(entry).booleanValue()) continue;
            if (this.userManager.getPrincipal(entry) != null) {
                returnList.add(entry);
                this.addUserGroupInCache(entry);
                continue;
            }
            if (this.userManager.getGroup(entry) != null) {
                returnList.add(entry);
                this.addUserGroupInCache(entry);
                continue;
            }
            this.addUserGroupInDeletedCache(entry);
        }
        return returnList;
    }

    private Boolean isUserGroupInCache(String entry) {
        if (this.cachedValidatedUserAndGroups == null) {
            return false;
        }
        return this.cachedValidatedUserAndGroups.contains(entry);
    }

    private void addUserGroupInCache(String entry) {
        if (this.cachedValidatedUserAndGroups == null) {
            this.cachedValidatedUserAndGroups = new ArrayList<String>();
        }
        this.cachedValidatedUserAndGroups.add(entry);
    }

    private Boolean isUserGroupInDeletedCache(String entry) {
        if (this.cachedDeletedUserAndGroups == null) {
            return false;
        }
        return this.cachedDeletedUserAndGroups.contains(entry);
    }

    private void addUserGroupInDeletedCache(String entry) {
        if (this.cachedDeletedUserAndGroups == null) {
            this.cachedDeletedUserAndGroups = new ArrayList<String>();
        }
        this.cachedDeletedUserAndGroups.add(entry);
    }

    private boolean checkPermissions() {
        if (this.currentUser.isAdministrator()) {
            return true;
        }
        ArrayList<String> principals = new ArrayList<String>();
        principals.add(this.currentUser.getName());
        principals.addAll(this.currentUser.getAllGroups());
        ACP acp = this.currentDocument.getACP();
        new SecurityDataConverter();
        List<UserEntry> modifiableEntries = SecurityDataConverter.convertToUserEntries(this.securityData);
        if (null == acp) {
            acp = new ACPImpl();
        }
        acp.setRules(modifiableEntries.toArray(new UserEntry[0]));
        boolean access = acp.getAccess(principals.toArray(new String[0]), this.getPermissionsToCheck()).toBoolean();
        if (!access) {
            this.rebuildSecurityData();
        }
        return access;
    }

    protected String[] getPermissionsToCheck() {
        if (this.CACHED_PERMISSION_TO_CHECK == null) {
            PermissionProvider pprovider = (PermissionProvider)Framework.getService(PermissionProvider.class);
            LinkedList<String> aggregatedPerms = new LinkedList<String>();
            for (String seedPerm : SEED_PERMISSIONS_TO_CHECK) {
                aggregatedPerms.add(seedPerm);
                String[] compoundPerms = pprovider.getPermissionGroups(seedPerm);
                if (compoundPerms == null) continue;
                aggregatedPerms.addAll(Arrays.asList(compoundPerms));
            }
            this.CACHED_PERMISSION_TO_CHECK = aggregatedPerms.toArray(new String[aggregatedPerms.size()]);
        }
        return this.CACHED_PERMISSION_TO_CHECK;
    }

    @Override
    public String getSelectedEntry() {
        return this.selectedEntry;
    }

    @Override
    public void setSelectedEntry(String selectedEntry) {
        this.selectedEntry = selectedEntry;
    }

    @Override
    public List<String> getSelectedEntries() {
        return this.selectedEntries;
    }

    @Override
    public void setSelectedEntries(List<String> selectedEntries) {
        this.selectedEntries = selectedEntries;
    }

    @Factory(value="isMSIEorEdge", scope=ScopeType.SESSION)
    public boolean isMSIEorEdge() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
            String ua = request.getHeader("User-Agent");
            return UserAgentMatcher.isMSIE6or7((String)ua) || UserAgentMatcher.isMSIE10OrMore((String)ua) || UserAgentMatcher.isMSEdge((String)ua);
        }
        return false;
    }

    public String getLabel(String permission) {
        return StringUtils.isNotBlank((CharSequence)permission) ? labeler.makeLabel(permission) : permission;
    }

    public Map<String, String> getPermissionsToLabels() {
        PermissionProvider permissionProvider = (PermissionProvider)Framework.getService(PermissionProvider.class);
        String[] permissions = permissionProvider.getPermissions();
        HashMap<String, String> permissionsToLabels = new HashMap<String, String>();
        for (String permission : permissions) {
            permissionsToLabels.put(permission, this.getLabel(permission));
        }
        return permissionsToLabels;
    }
}

