/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jsf.operations;

import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;

@Operation(id="Seam.AddMessage", category="User Interface", requires="Seam", label="Add Message", description="Add a feedback message to be displayed. The message will be internationalized. You can specify the severity of the message using INFO, WARN and ERROR, default is INFO. Messages parameters are extracted from the context using the 'AddMessage.messageParams'.", aliases={"WebUI.AddMessage"})
public class AddMessage {
    public static final String ID = "Seam.AddMessage";
    public static final String MESSAGE_PARAMS_KEY = "AddMessage.messageParams";
    @Context
    protected OperationContext ctx;
    @Param(name="message")
    protected String message;
    @Param(name="severity")
    protected String severityStr = StatusMessage.Severity.INFO.name();

    @OperationMethod
    public void run() {
        StatusMessage.Severity severity = StatusMessage.Severity.valueOf((String)this.severityStr);
        FacesMessages facesMessages = (FacesMessages)Contexts.getConversationContext().get(FacesMessages.class);
        Object[] params = (Object[])this.ctx.get((Object)MESSAGE_PARAMS_KEY);
        if (params == null) {
            params = new Object[]{};
        }
        facesMessages.addFromResourceBundle(severity, this.message, params);
    }
}

