/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.action;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.Messages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.automation.core.util.DataModelProperties;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchManager;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.SimpleDocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.rest.FancyNavigationHandler;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.ExceptionHelper;
import org.nuxeo.ecm.webapp.dnd.DndConfigurationHelper;
import org.nuxeo.ecm.webapp.filemanager.FileManageActionsBean;
import org.nuxeo.ecm.webapp.filemanager.NxUploadedFile;
import org.nuxeo.runtime.api.Framework;
import org.richfaces.event.FileUploadEvent;

@Name(value="importActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class ImportActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ImportActions.class);
    public static final String LABEL_IMPORT_PROBLEM = "label.bulk.import.documents.error";
    public static final String LABEL_IMPORT_CANNOT_CREATE_ERROR = "label.bulk.import.documents.cannotCreateError";
    public static final String DOCUMENTS_IMPORTED = "documentImported";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected NavigationContext navigationContext;
    @In(create=true)
    protected transient WebActions webActions;
    @In(create=true)
    protected transient DndConfigurationHelper dndConfigHelper;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected Map<String, String> messages;
    @RequestParameter
    protected String fancyboxFormId;
    protected DocumentModel importDocumentModel;
    protected Action selectedImportOption;
    protected List<Action> importOptions;
    protected String selectedImportFolderId;
    protected String currentBatchId;
    protected Collection<NxUploadedFile> uploadedFiles = null;

    public DocumentModel getImportDocumentModel() {
        if (this.importDocumentModel == null) {
            this.importDocumentModel = new SimpleDocumentModel();
        }
        return this.importDocumentModel;
    }

    public String getSelectedImportOptionId() {
        if (this.selectedImportOption == null) {
            this.selectedImportOption = this.importOptions != null && this.importOptions.size() > 0 ? this.importOptions.get(0) : null;
        }
        return this.selectedImportOption != null ? this.selectedImportOption.getId() : null;
    }

    public void setSelectedImportOptionId(String id) {
        for (Action importOption : this.importOptions) {
            if (!importOption.getId().equals(id)) continue;
            this.selectedImportOption = importOption;
            break;
        }
    }

    public Action getSelectedImportOption() {
        if (this.selectedImportOption == null) {
            this.selectedImportOption = this.importOptions != null && this.importOptions.size() > 0 ? this.importOptions.get(0) : null;
        }
        return this.selectedImportOption;
    }

    public List<Action> getImportOptions(String dropContext) {
        if (this.importOptions == null) {
            this.importOptions = new ArrayList<Action>();
            this.importOptions.addAll(this.webActions.getActionsList(dropContext));
        }
        return this.importOptions;
    }

    public String getSelectedImportFolderId() {
        if (this.selectedImportFolderId == null) {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            if (currentDocument == null) {
                return null;
            }
            if (currentDocument.isFolder() && !"/".equals(currentDocument.getPathAsString()) && this.documentManager.hasPermission(currentDocument.getRef(), "AddChildren")) {
                this.selectedImportFolderId = currentDocument.getId();
            } else {
                List parents = this.documentManager.getParentDocuments(currentDocument.getRef());
                Collections.reverse(parents);
                for (DocumentModel parent : parents) {
                    if (!parent.isFolder() || !this.documentManager.hasPermission(parent.getRef(), "AddChildren")) continue;
                    this.selectedImportFolderId = parent.getId();
                    break;
                }
            }
        }
        return this.selectedImportFolderId;
    }

    public void setSelectedImportFolderId(String selectedImportFolderId) {
        this.selectedImportFolderId = selectedImportFolderId;
    }

    public String generateBatchId() {
        if (this.currentBatchId == null) {
            BatchManager batchManager = (BatchManager)Framework.getService(BatchManager.class);
            this.currentBatchId = batchManager.initBatch();
        }
        return this.currentBatchId;
    }

    public boolean hasUploadedFiles() {
        if (this.currentBatchId != null) {
            BatchManager batchManager = (BatchManager)Framework.getService(BatchManager.class);
            return batchManager.hasBatch(this.currentBatchId);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String importDocuments() {
        Map importOptionProperties = this.selectedImportOption.getProperties();
        String chainOrOperationId = null;
        chainOrOperationId = importOptionProperties.containsKey("chainId") ? (String)importOptionProperties.get("chainId") : (importOptionProperties.containsKey("operationId") ? (String)importOptionProperties.get("operationId") : this.selectedImportOption.getId());
        ArrayList<DataModel> dms = new ArrayList<DataModel>();
        for (String schema : this.importDocumentModel.getSchemas()) {
            dms.add(this.importDocumentModel.getDataModel(schema));
        }
        DataModelProperties properties = new DataModelProperties(dms, true);
        HashMap<String, Object> contextParams = new HashMap<String, Object>();
        contextParams.put("docMetaData", properties);
        contextParams.put("currentDocument", this.selectedImportFolderId);
        boolean resetBatchState = true;
        try {
            List<DocumentModel> importedDocuments = this.dndConfigHelper.useHtml5DragAndDrop() ? this.importDocumentsThroughBatchManager(chainOrOperationId, contextParams) : this.importDocumentsThroughUploadItems(chainOrOperationId, contextParams);
            Events.instance().raiseEvent(DOCUMENTS_IMPORTED, new Object[]{importedDocuments, this.importDocumentModel});
            if (this.selectedImportFolderId != null) {
                String string = this.navigationContext.navigateToRef((DocumentRef)new IdRef(this.selectedImportFolderId));
                return string;
            }
        }
        catch (NuxeoException e) {
            log.debug((Object)e, (Throwable)e);
            Throwable t = ExceptionHelper.unwrapException((Throwable)e);
            if (t.getMessage().contains("Cannot create")) {
                resetBatchState = false;
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, (String)Messages.instance().get(LABEL_IMPORT_CANNOT_CREATE_ERROR), null);
                FacesContext faces = FacesContext.getCurrentInstance();
                if (this.fancyboxFormId != null && this.fancyboxFormId.startsWith(":")) {
                    faces.addMessage(this.fancyboxFormId.substring(1), message);
                } else {
                    faces.addMessage(this.fancyboxFormId, message);
                }
                HttpServletRequest httpRequest = (HttpServletRequest)faces.getExternalContext().getRequest();
                httpRequest.setAttribute(FancyNavigationHandler.DISABLE_REDIRECT_FOR_URL_REWRITE, (Object)Boolean.TRUE);
            } else {
                this.facesMessages.addFromResourceBundle(StatusMessage.Severity.ERROR, (String)Messages.instance().get(LABEL_IMPORT_PROBLEM), new Object[0]);
            }
        }
        finally {
            if (resetBatchState) {
                this.cancel();
            }
        }
        return null;
    }

    protected List<DocumentModel> importDocumentsThroughBatchManager(String chainOrOperationId, Map<String, Object> contextParams) {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        return (List)bm.execute(this.currentBatchId, chainOrOperationId, this.documentManager, contextParams, null);
    }

    /*
     * Exception decompiling
     */
    protected List<DocumentModel> importDocumentsThroughUploadItems(String chainOrOperationId, Map<String, Object> contextParams) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void cancel() {
        if (this.currentBatchId != null) {
            BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
            bm.clean(this.currentBatchId);
        }
        this.importDocumentModel = null;
        this.selectedImportFolderId = null;
        this.uploadedFiles = null;
        this.currentBatchId = null;
    }

    public Collection<NxUploadedFile> getUploadedFiles() {
        if (this.uploadedFiles == null) {
            this.uploadedFiles = new ArrayList<NxUploadedFile>();
        }
        return this.uploadedFiles;
    }

    public void setUploadedFiles(Collection<NxUploadedFile> uploadedFiles) {
        this.uploadedFiles = uploadedFiles;
    }

    @Observer(value={"userAllDocumentTypesSelectionChanged"})
    public void invalidateSelectedImportFolder() {
        this.selectedImportFolderId = null;
    }

    public void processUpload(FileUploadEvent uploadEvent) {
        try {
            if (this.uploadedFiles == null) {
                this.uploadedFiles = new ArrayList<NxUploadedFile>();
            }
            FileBlob blob = FileManageActionsBean.getBlob(uploadEvent);
            this.uploadedFiles.add(new NxUploadedFile((Blob)blob));
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
    }
}

