/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.message;

import com.sun.faces.renderkit.html_basic.MessagesRenderer;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessages;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import org.apache.commons.text.StringEscapeUtils;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.runtime.api.Framework;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public class NXMessagesRenderer
extends MessagesRenderer
implements ComponentSystemEventListener {
    public static final String RENDERER_TYPE = "javax.faces.NXMessages";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        boolean mustRender = this.shouldWriteIdAttribute(component);
        UIMessages messages = (UIMessages)component;
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        String clientId = ((UIMessages)component).getFor();
        if (clientId == null && messages.isGlobalOnly()) {
            clientId = "";
        }
        Iterator messageIter = this.getMessageIter(context, clientId, component);
        assert (messageIter != null);
        if (!messageIter.hasNext()) {
            if (mustRender) {
                if ("javax_faces_developmentstage_messages".equals(component.getId())) {
                    return;
                }
                writer.startElement("div", component);
                this.writeIdAttributeIfNecessary(context, writer, component);
                writer.endElement("div");
            }
            return;
        }
        boolean showDetail = messages.isShowDetail();
        while (messageIter.hasNext()) {
            FacesMessage curMessage = (FacesMessage)messageIter.next();
            if (curMessage.isRendered() && !messages.isRedisplay()) continue;
            curMessage.rendered();
            String summary = curMessage.getSummary();
            summary = null != summary ? summary : "";
            String detail = curMessage.getDetail();
            detail = null != detail ? detail : summary;
            String severityStyleClass = null;
            String errorType = "default";
            long timeout = 5L;
            if (curMessage.getSeverity() == FacesMessage.SEVERITY_INFO) {
                severityStyleClass = (String)component.getAttributes().get("infoClass");
                errorType = "info";
            } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_WARN) {
                severityStyleClass = (String)component.getAttributes().get("warnClass");
                errorType = "warn";
            } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_ERROR) {
                severityStyleClass = (String)component.getAttributes().get("errorClass");
                errorType = "error";
                timeout = 0L;
            } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_FATAL) {
                severityStyleClass = (String)component.getAttributes().get("fatalClass");
                errorType = "fatal";
                timeout = 0L;
            }
            if (Framework.getProperty((String)"org.nuxeo.ecm.tester.name") != null) {
                timeout = 0L;
            }
            writer.startElement("script", (UIComponent)messages);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            String message = "";
            if (showDetail) {
                message = detail;
            }
            String scriptContent = "jQuery(document).ready(function() {\n" + "  jQuery.ambiance({\n" + "    message: \"" + StringEscapeUtils.escapeEcmaScript((String)StringEscapeUtils.escapeHtml4((String)message)) + "\",\n" + "    title: \"" + StringEscapeUtils.escapeEcmaScript((String)StringEscapeUtils.escapeHtml4((String)summary)) + "\",\n" + "    type: \"" + errorType + "\",\n" + "    className: \"" + severityStyleClass + "\",\n" + "    timeout: \"" + timeout + "\"" + "  })\n" + "});\n";
            writer.writeText((Object)scriptContent, null);
            writer.endElement("script");
        }
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        UIComponent component = event.getComponent();
        if (ComponentUtils.isRelocated(component)) {
            return;
        }
        String target = this.verifyTarget((String)component.getAttributes().get("target"));
        if (target != null) {
            ComponentUtils.relocate(component, target, null);
        }
    }

    protected String verifyTarget(String toVerify) {
        return ComponentUtils.verifyTarget(toVerify, toVerify);
    }
}

