/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import yarfraw.core.datamodel.ChannelFeed;
import yarfraw.core.datamodel.FeedFormat;
import yarfraw.core.datamodel.YarfrawException;
import yarfraw.generated.rss10.elements.RDF;
import yarfraw.generated.rss20.elements.TRss;
import yarfraw.io.AbstractBaseFeedParser;
import yarfraw.mapping.backward.impl.ToChannelAtom03Impl;
import yarfraw.mapping.backward.impl.ToChannelAtom10Impl;
import yarfraw.mapping.backward.impl.ToChannelRss10Impl;
import yarfraw.mapping.backward.impl.ToChannelRss20Impl;
import yarfraw.utils.JAXBUtils;

public class FeedReader
extends AbstractBaseFeedParser {
    private static final Log LOG = LogFactory.getLog(FeedReader.class);

    public FeedReader(File file, FeedFormat format) {
        super(file, format);
    }

    public FeedReader(String pathName, FeedFormat format) {
        super(new File(pathName), format);
    }

    public FeedReader(URI uri, FeedFormat format) {
        super(new File(uri), format);
    }

    public FeedReader(File file) {
        super(file);
    }

    public FeedReader(String pathName) {
        super(new File(pathName));
    }

    public FeedReader(URI uri) {
        super(new File(uri));
    }

    public FeedReader(HttpURL httpUrl, HttpClientParams params) throws YarfrawException, IOException {
        super(httpUrl, params);
    }

    public FeedReader(HttpURL httpUrl) throws YarfrawException, IOException {
        super(httpUrl, null);
    }

    public FeedReader(GetMethod getMethod) throws YarfrawException, IOException {
        super(getMethod);
    }

    public static ChannelFeed readChannel(FeedFormat format, InputStream inputStream) throws YarfrawException {
        try {
            Unmarshaller u = FeedReader.getUnMarshaller(format);
            return FeedReader.toChannel(format, u.unmarshal(inputStream));
        }
        catch (JAXBException e) {
            throw new YarfrawException("Unable to unmarshal file", e);
        }
    }

    public ChannelFeed readChannel(ValidationEventHandler validationEventHandler) throws YarfrawException {
        InputStream input = null;
        try {
            input = this.getStream();
            if (input == null) {
                LOG.warn((Object)"Unable to read from null stream, returning null");
                ChannelFeed channelFeed = null;
                return channelFeed;
            }
            Unmarshaller u = FeedReader.getUnMarshaller(this._format);
            if (validationEventHandler != null) {
                u.setEventHandler(validationEventHandler);
            }
            ChannelFeed channelFeed = FeedReader.toChannel(this._format, u.unmarshal(input));
            return channelFeed;
        }
        catch (JAXBException e) {
            throw new YarfrawException("Unable to unmarshal file", e);
        }
        catch (HttpException e) {
            throw new YarfrawException("Unable to read from remote url", e);
        }
        catch (IOException e) {
            throw new YarfrawException("Unable to read", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    private static ChannelFeed toChannel(FeedFormat format, Object o) throws YarfrawException {
        if (format == FeedFormat.RSS20) {
            return (ChannelFeed)ToChannelRss20Impl.getInstance().execute(((TRss)((JAXBElement)o).getValue()).getChannel());
        }
        if (format == FeedFormat.RSS10) {
            return (ChannelFeed)ToChannelRss10Impl.getInstance().execute((RDF)o);
        }
        if (format == FeedFormat.ATOM10) {
            return (ChannelFeed)ToChannelAtom10Impl.getInstance().execute(((JAXBElement)o).getValue());
        }
        if (format == FeedFormat.ATOM03) {
            return (ChannelFeed)ToChannelAtom03Impl.getInstance().execute(((JAXBElement)o).getValue());
        }
        throw new UnsupportedOperationException("Unknown Feed Format");
    }

    public ChannelFeed readChannel() throws YarfrawException {
        return this.readChannel(null);
    }

    private static Unmarshaller getUnMarshaller(FeedFormat format) throws JAXBException {
        JAXBContext context = JAXBUtils.getContext(format);
        Unmarshaller u = context.createUnmarshaller();
        u.setEventHandler((ValidationEventHandler)new WarningHandler());
        return u;
    }

    private static class WarningHandler
    implements ValidationEventHandler {
        private WarningHandler() {
        }

        public boolean handleEvent(ValidationEvent event) {
            DefaultValidationEventHandler d = new DefaultValidationEventHandler();
            d.handleEvent(event);
            return event.getSeverity() == 2;
        }
    }
}

