/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.core.datamodel;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import yarfraw.core.datamodel.AbstractBaseObject;
import yarfraw.core.datamodel.CategorySubject;
import yarfraw.core.datamodel.Cloud;
import yarfraw.core.datamodel.Day;
import yarfraw.core.datamodel.FeedFormat;
import yarfraw.core.datamodel.Generator;
import yarfraw.core.datamodel.Id;
import yarfraw.core.datamodel.Image;
import yarfraw.core.datamodel.ItemEntry;
import yarfraw.core.datamodel.Link;
import yarfraw.core.datamodel.Person;
import yarfraw.core.datamodel.Text;
import yarfraw.core.datamodel.TextInput;
import yarfraw.core.datamodel.ValidationException;
import yarfraw.utils.ValidationUtils;
import yarfraw.utils.XMLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelFeed
extends AbstractBaseObject {
    private static final long serialVersionUID = 20070927L;
    private static final Log LOG = LogFactory.getLog(ChannelFeed.class);
    private List<ItemEntry> _items;
    private Text _title;
    private List<Link> _links;
    private Text _descriptionOrSubtitle;
    private Text _rights;
    private List<Person> _managingEditorOrAuthorOrPublisher;
    private List<Person> _webMasterOrCreator;
    private List<Person> _contributors;
    private Set<CategorySubject> _categorySubjects;
    private String _pubDate;
    private String _lastBuildOrUpdatedDate;
    private Id _uid;
    private Generator _generator;
    private String _docs;
    private Integer _ttl;
    private Cloud _cloud;
    private Image _imageOrIcon;
    private Image _logo;
    private TextInput _texInput;
    private Set<Integer> _skipHours;
    private Set<Day> _skipDays;

    public List<ItemEntry> getItems() {
        return this._items;
    }

    public ChannelFeed setItems(List<ItemEntry> items) {
        this._items = items;
        return this;
    }

    public ChannelFeed addItem(ItemEntry ... items) {
        if (ArrayUtils.isEmpty((Object[])items)) {
            LOG.warn((Object)"Empty items array is ignored");
            return this;
        }
        if (this._items == null) {
            this._items = new ArrayList<ItemEntry>();
        }
        for (ItemEntry item : items) {
            this._items.add(item);
        }
        return this;
    }

    public Text getTitle() {
        return this._title;
    }

    public String getTitleText() {
        return this._title == null ? null : this._title.getText();
    }

    public ChannelFeed setTitle(Text title) {
        this._title = title;
        return this;
    }

    public ChannelFeed setTitle(String title) {
        if (title == null) {
            this._title = null;
            return this;
        }
        return this.setTitle(new Text(title));
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public ChannelFeed setLinks(List<Link> links) {
        this._links = links;
        return this;
    }

    public ChannelFeed addLink(String ... href) {
        if (ArrayUtils.isEmpty((Object[])href)) {
            LOG.warn((Object)"Empty href array is ignored");
            return this;
        }
        if (this._links == null) {
            this._links = new ArrayList<Link>();
        }
        for (String s : href) {
            this._links.add(new Link(s));
        }
        return this;
    }

    public ChannelFeed addLink(Link ... link) {
        if (ArrayUtils.isEmpty((Object[])link)) {
            LOG.warn((Object)"Empty link array is ignored");
            return this;
        }
        if (this._links == null) {
            this._links = new ArrayList<Link>();
        }
        for (Link l : link) {
            this._links.add(l);
        }
        return this;
    }

    public Text getDescriptionOrSubtitle() {
        return this._descriptionOrSubtitle;
    }

    public String getDescriptionOrSubtitleText() {
        return this._descriptionOrSubtitle == null ? null : this._descriptionOrSubtitle.getText();
    }

    public ChannelFeed setDescriptionOrSubtitle(Text descriptionOrSubtitle) {
        this._descriptionOrSubtitle = descriptionOrSubtitle;
        return this;
    }

    public ChannelFeed setDescriptionOrSubtitle(String descriptionOrSubtitle) {
        this._descriptionOrSubtitle = descriptionOrSubtitle == null ? null : new Text(descriptionOrSubtitle);
        return this;
    }

    public Text getRights() {
        return this._rights;
    }

    public String getRightsText() {
        return this._rights == null ? null : this._rights.getText();
    }

    public ChannelFeed setRights(Text rights) {
        this._rights = rights;
        return this;
    }

    public ChannelFeed setRights(String rights) {
        if (rights == null) {
            this._rights = null;
            return this;
        }
        return this.setRights(new Text(rights));
    }

    public List<Person> getManagingEditorOrAuthorOrPublisher() {
        return this._managingEditorOrAuthorOrPublisher;
    }

    public ChannelFeed setManagingEditorOrAuthorOrPublisher(List<Person> managingEditorOrAuthorOrPublisher) {
        this._managingEditorOrAuthorOrPublisher = managingEditorOrAuthorOrPublisher;
        return this;
    }

    public ChannelFeed addManagingEditorOrAuthorOrPublisher(String ... emails) {
        if (ArrayUtils.isEmpty((Object[])emails)) {
            LOG.warn((Object)"Empty email array is ignored");
            return this;
        }
        if (this._managingEditorOrAuthorOrPublisher == null) {
            this._managingEditorOrAuthorOrPublisher = new ArrayList<Person>();
        }
        for (String s : emails) {
            this._managingEditorOrAuthorOrPublisher.add(new Person(s));
        }
        return this;
    }

    public ChannelFeed addManagingEditorOrAuthorOrPublisher(Person ... persons) {
        if (ArrayUtils.isEmpty((Object[])persons)) {
            LOG.warn((Object)"Empty email array is ignored");
            return this;
        }
        if (this._managingEditorOrAuthorOrPublisher == null) {
            this._managingEditorOrAuthorOrPublisher = new ArrayList<Person>();
        }
        for (Person p : persons) {
            this._managingEditorOrAuthorOrPublisher.add(p);
        }
        return this;
    }

    public List<Person> getWebMasterOrCreator() {
        return this._webMasterOrCreator;
    }

    public ChannelFeed setWebMasterOrCreator(List<Person> webMasterOrCreator) {
        this._webMasterOrCreator = webMasterOrCreator;
        return this;
    }

    public ChannelFeed addWebMasterOrCreator(Person ... webMasterOrCreator) {
        if (ArrayUtils.isEmpty((Object[])webMasterOrCreator)) {
            LOG.warn((Object)"empty person array is ignored");
            return this;
        }
        if (this._webMasterOrCreator == null) {
            this._webMasterOrCreator = new ArrayList<Person>();
        }
        for (Person p : webMasterOrCreator) {
            this._webMasterOrCreator.add(p);
        }
        return this;
    }

    public ChannelFeed addWebMasterOrCreator(String ... emailOrText) {
        if (ArrayUtils.isEmpty((Object[])emailOrText)) {
            LOG.warn((Object)"empty array is ignored");
            return this;
        }
        if (this._webMasterOrCreator == null) {
            this._webMasterOrCreator = new ArrayList<Person>();
        }
        for (String e : emailOrText) {
            this._webMasterOrCreator.add(new Person(e));
        }
        return this;
    }

    public List<Person> getContributors() {
        return this._contributors;
    }

    public ChannelFeed setContributors(List<Person> contributors) {
        this._contributors = contributors;
        return this;
    }

    public ChannelFeed addContributor(Person ... contributor) {
        if (ArrayUtils.isEmpty((Object[])contributor)) {
            LOG.warn((Object)"empty person array is ignored");
            return this;
        }
        if (this._contributors == null) {
            this._contributors = new ArrayList<Person>();
        }
        for (Person p : contributor) {
            this._contributors.add(p);
        }
        return this;
    }

    public ChannelFeed addContributor(String ... emailOrText) {
        if (ArrayUtils.isEmpty((Object[])emailOrText)) {
            LOG.warn((Object)"empty array is ignored");
            return this;
        }
        if (this._contributors == null) {
            this._contributors = new ArrayList<Person>();
        }
        for (String e : emailOrText) {
            this._contributors.add(new Person(e));
        }
        return this;
    }

    public Set<CategorySubject> getCategorySubjects() {
        return this._categorySubjects;
    }

    public ChannelFeed setCategorySubjects(Set<CategorySubject> categorySubjects) {
        this._categorySubjects = categorySubjects;
        return this;
    }

    public ChannelFeed addCategorySubject(String ... categorySubjectOrTerm) {
        if (ArrayUtils.isEmpty((Object[])categorySubjectOrTerm)) {
            LOG.warn((Object)"Empty category array is ignored");
            return this;
        }
        if (this._categorySubjects == null) {
            this._categorySubjects = new HashSet<CategorySubject>();
        }
        for (String c : categorySubjectOrTerm) {
            this._categorySubjects.add(new CategorySubject(c));
        }
        return this;
    }

    public ChannelFeed addCategorySubject(CategorySubject ... categorySubject) {
        if (ArrayUtils.isEmpty((Object[])categorySubject)) {
            LOG.warn((Object)"Empty category array is ignored");
            return this;
        }
        if (this._categorySubjects == null) {
            this._categorySubjects = new HashSet<CategorySubject>();
        }
        for (CategorySubject s : categorySubject) {
            this._categorySubjects.add(s);
        }
        return this;
    }

    public String getPubDate() {
        return this._pubDate;
    }

    public ChannelFeed setPubDate(String pubDate) {
        this._pubDate = pubDate;
        return this;
    }

    public ChannelFeed setPubDate(Date pubDate, SimpleDateFormat format) {
        this._pubDate = format.format(pubDate);
        return this;
    }

    public String getLastBuildOrUpdatedDate() {
        return this._lastBuildOrUpdatedDate;
    }

    public ChannelFeed setLastBuildOrUpdatedDate(String lastBuildOrUpdatedDate) {
        this._lastBuildOrUpdatedDate = lastBuildOrUpdatedDate;
        return this;
    }

    public ChannelFeed setLastBuildOrUpdatedDate(Date lastBuildOrUpdatedDate, SimpleDateFormat format) {
        return this.setLastBuildOrUpdatedDate(format.format(lastBuildOrUpdatedDate));
    }

    public Id getUid() {
        return this._uid;
    }

    public ChannelFeed setUid(Id uid) {
        this._uid = uid;
        return this;
    }

    public ChannelFeed setUid(String uid) {
        if (this._uid == null) {
            this._uid = null;
            return this;
        }
        this._uid = new Id(uid);
        return this;
    }

    public Generator getGenerator() {
        return this._generator;
    }

    public ChannelFeed setGenerator(Generator generator) {
        this._generator = generator;
        return this;
    }

    public ChannelFeed setGenerator(String generatorValue) {
        this._generator = generatorValue == null ? null : new Generator(generatorValue);
        return this;
    }

    public String getDocs() {
        return this._docs;
    }

    public ChannelFeed setDocs(String docs) {
        this._docs = docs;
        return this;
    }

    public Integer getTtl() {
        return this._ttl;
    }

    public ChannelFeed setTtl(Integer ttl) {
        this._ttl = ttl;
        return this;
    }

    public Cloud getCloud() {
        return this._cloud;
    }

    public ChannelFeed setCloud(Cloud cloud) {
        this._cloud = cloud;
        return this;
    }

    public Image getImageOrIcon() {
        return this._imageOrIcon;
    }

    public ChannelFeed setImageOrIcon(Image imageOrIcon) {
        this._imageOrIcon = imageOrIcon;
        return this;
    }

    public Image getLogo() {
        return this._logo;
    }

    public ChannelFeed setLogo(Image logo) {
        this._logo = logo;
        return this;
    }

    public TextInput getTexInput() {
        return this._texInput;
    }

    public ChannelFeed setTexInput(TextInput texInput) {
        this._texInput = texInput;
        return this;
    }

    public Set<Integer> getSkipHours() {
        return this._skipHours;
    }

    public ChannelFeed setSkipHours(Set<Integer> skipHours) {
        for (Integer i : skipHours) {
            if (i != null && i >= 0 && i <= 23) continue;
            throw new IllegalArgumentException("all skip hour must be a value that is a number between 0 and 23");
        }
        this._skipHours = skipHours;
        return this;
    }

    public ChannelFeed addSkipHour(int ... hour) {
        if (!ArrayUtils.isEmpty((int[])hour)) {
            for (int h : hour) {
                if (h < 0 || h > 23) {
                    throw new IllegalArgumentException("all skip hour must be a value that is a number between 0 and 23");
                }
                if (this._skipHours == null) {
                    this._skipHours = new HashSet<Integer>();
                }
                this._skipHours.add(h);
            }
        }
        return this;
    }

    public Set<Day> getSkipDays() {
        return this._skipDays;
    }

    public ChannelFeed setSkipDays(Set<Day> skipDays) {
        this._skipDays = skipDays;
        return this;
    }

    public ChannelFeed addSkipDay(Day ... day) {
        if (!ArrayUtils.isEmpty((Object[])day)) {
            if (this._skipDays == null) {
                this._skipDays = new HashSet<Day>();
            }
            this._skipDays.addAll(Arrays.asList(day));
        }
        return this;
    }

    public ChannelFeed setOtherAttributes(Map<QName, String> otherAttributes) {
        this._otherAttributes = otherAttributes;
        return this;
    }

    public ChannelFeed addOtherAttributes(QName namespace, String attribute) {
        if (this._otherAttributes == null) {
            this._otherAttributes = new HashMap();
        }
        this._otherAttributes.put(namespace, attribute);
        return this;
    }

    public ChannelFeed setOtherElements(List<Element> otherElements) {
        this._otherElements = otherElements;
        return this;
    }

    public ChannelFeed addOtherElement(Element element) {
        if (this._otherElements == null) {
            this._otherElements = new ArrayList();
        }
        this._otherElements.add(element);
        return this;
    }

    public ChannelFeed addOtherElement(String xmlString) throws SAXException, IOException, ParserConfigurationException {
        return this.addOtherElement(XMLUtils.parseXml(xmlString, false, false).getDocumentElement());
    }

    public ChannelFeed setBase(String base) {
        this._base = base;
        return this;
    }

    public ChannelFeed setLang(String lang) {
        this._lang = lang;
        return this;
    }

    public ChannelFeed setLang(Locale lang) {
        this._lang = lang.getLanguage();
        return this;
    }

    public ChannelFeed setResource(String resource) {
        this._resource = resource;
        return this;
    }

    public ChannelFeed setAbout(String about) {
        this._about = about;
        return this;
    }

    @Override
    public void validate(FeedFormat format) throws ValidationException {
        if (CollectionUtils.isEmpty(this._items)) {
            throw new ValidationException("Channel: You should have at least 1 item");
        }
        for (ItemEntry item : this._items) {
            ValidationUtils.validateNotNull("Channel: All item should not be null", item);
            item.validate(format);
        }
        ValidationUtils.validateNotNull("Channel: Title, Link and Description should not be null", this._title, this._links, this._descriptionOrSubtitle);
        this._title.validate(format);
        this._descriptionOrSubtitle.validate(format);
        for (Link l : this._links) {
            l.validate(format);
        }
        if (this._categorySubjects != null) {
            for (CategorySubject c : this._categorySubjects) {
                c.validate(format);
            }
        }
        if (this._cloud != null) {
            this._cloud.validate(format);
        }
        if (this._imageOrIcon != null) {
            this._imageOrIcon.validate(format);
        }
        if (this._logo != null) {
            this._logo.validate(format);
        }
        if (this._texInput != null) {
            this._texInput.validate(format);
        }
        if (this._uid != null) {
            this._uid.validate(format);
        }
        if (this._generator != null) {
            this._generator.validate(format);
        }
        if (this._contributors != null) {
            for (Person p : this._contributors) {
                p.validate(format);
            }
        }
        if (this._managingEditorOrAuthorOrPublisher != null) {
            for (Person p : this._managingEditorOrAuthorOrPublisher) {
                p.validate(format);
            }
        }
        if (this._webMasterOrCreator != null) {
            for (Person p : this._webMasterOrCreator) {
                p.validate(format);
            }
        }
        if (this._rights != null) {
            this._rights.validate(format);
        }
    }
}

