/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.preview.restlet;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.platform.preview.api.HtmlPreviewAdapter;
import org.nuxeo.ecm.platform.preview.api.NothingToPreviewException;
import org.nuxeo.ecm.platform.preview.api.PreviewException;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseStatelessNuxeoRestlet;
import org.nuxeo.runtime.api.Framework;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Status;

public class PreviewRestlet
extends BaseStatelessNuxeoRestlet {
    private static final Log log = LogFactory.getLog(PreviewRestlet.class);
    public static final String PREVIEWURL_DEFAULTXPATH = "default";
    protected static final List<String> previewInProcessing = Collections.synchronizedList(new ArrayList());

    public void doHandleStatelessRequest(Request req, Response res) {
        int pos;
        this.logDeprecation();
        HttpServletRequest request = PreviewRestlet.getHttpRequest((Request)req);
        HttpServletResponse response = PreviewRestlet.getHttpResponse((Response)res);
        String repo = (String)req.getAttributes().get("repo");
        String docid = (String)req.getAttributes().get("docid");
        String xpath = (String)req.getAttributes().get("fieldPath");
        xpath = xpath.replace("-", "/");
        List segments = req.getResourceRef().getSegments();
        StringBuilder sb = new StringBuilder();
        for (int i = pos = segments.indexOf("restAPI") + 5; i < segments.size(); ++i) {
            sb.append((String)segments.get(i));
            sb.append("/");
        }
        String subPath = sb.substring(0, sb.length() - 1);
        try {
            xpath = URLDecoder.decode(xpath, "UTF-8");
            subPath = URLDecoder.decode(subPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
        }
        String blobPostProcessingParameter = PreviewRestlet.getQueryParamValue((Request)req, (String)"blobPostProcessing", (String)"false");
        boolean blobPostProcessing = Boolean.parseBoolean(blobPostProcessingParameter);
        if (repo == null || repo.equals("*")) {
            PreviewRestlet.handleError((Response)res, (String)"you must specify a repository");
            return;
        }
        if (docid == null || repo.equals("*")) {
            PreviewRestlet.handleError((Response)res, (String)"you must specify a documentId");
            return;
        }
        boolean initOk = this.initRepositoryAndTargetDocument(res, repo, docid);
        if (!initOk) {
            return;
        }
        Blob blobToPreview = this.getBlobToPreview(xpath);
        BlobManager blobManager = (BlobManager)Framework.getService(BlobManager.class);
        try {
            URI uri = blobManager.getURI(blobToPreview, BlobManager.UsageHint.EMBED, null);
            if (uri != null) {
                res.redirectSeeOther(uri.toString());
                return;
            }
        }
        catch (IOException e) {
            PreviewRestlet.handleError((Response)res, (Exception)e);
            return;
        }
        List<Blob> previewBlobs = this.initCachedBlob(res, xpath, blobPostProcessing);
        if (previewBlobs == null || previewBlobs.isEmpty()) {
            return;
        }
        Blob blob = null;
        if (StringUtils.isEmpty((CharSequence)subPath)) {
            blob = previewBlobs.get(0);
            blob.setMimeType("text/html");
        } else {
            for (Blob b : previewBlobs) {
                if (!subPath.equals(b.getFilename())) continue;
                blob = b;
                break;
            }
        }
        if (blob == null) {
            res.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return;
        }
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        String reason = "preview";
        Blob fblob = blob;
        if (xpath == null || PREVIEWURL_DEFAULTXPATH.equals(xpath)) {
            xpath = "blobholder:0";
        }
        Boolean inline = Boolean.TRUE;
        Map<String, String> extendedInfos = Collections.singletonMap("subPath", subPath);
        DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
        try {
            downloadService.downloadBlob(request, response, this.targetDocument, xpath, blob, blob.getFilename(), reason, extendedInfos, inline, byteRange -> this.setEntityToBlobOutput(fblob, (DownloadService.ByteRange)byteRange, res));
        }
        catch (IOException e) {
            PreviewRestlet.handleError((Response)res, (Exception)e);
        }
    }

    private Blob getBlobToPreview(String xpath) {
        Object bh = xpath == null || PREVIEWURL_DEFAULTXPATH.equals(xpath) ? (BlobHolder)this.targetDocument.getAdapter(BlobHolder.class) : new DocumentBlobHolder(this.targetDocument, xpath);
        return bh.getBlob();
    }

    private List<Blob> initCachedBlob(Response res, String xpath, boolean blobPostProcessing) {
        HtmlPreviewAdapter preview = null;
        this.targetDocument.putContextData("nuxeo.old.jsf.preview", (Serializable)Boolean.valueOf(true));
        preview = (HtmlPreviewAdapter)this.targetDocument.getAdapter(HtmlPreviewAdapter.class);
        if (preview == null) {
            this.handleNoPreview(res, xpath, null);
            return null;
        }
        List previewBlobs = null;
        try {
            previewBlobs = xpath.equals(PREVIEWURL_DEFAULTXPATH) ? preview.getFilePreviewBlobs(blobPostProcessing) : preview.getFilePreviewBlobs(xpath, blobPostProcessing);
        }
        catch (PreviewException e) {
            previewInProcessing.remove(this.targetDocument.getId());
            this.handleNoPreview(res, xpath, (Exception)((Object)e));
            return null;
        }
        if (previewBlobs == null || previewBlobs.size() == 0) {
            this.handleNoPreview(res, xpath, null);
            return null;
        }
        return previewBlobs;
    }

    protected void handleNoPreview(Response res, String xpath, Exception e) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body><center><h1>");
        if (e == null) {
            sb.append("No preview is available for this document.</h1>");
        } else {
            sb.append("Preview cannot be generated for this document.</h1>");
            sb.append("<pre>Technical issue:</pre>");
            sb.append("<pre>Blob path: ");
            sb.append(xpath);
            sb.append("</pre>");
            sb.append("<pre>");
            sb.append(e.toString());
            sb.append("</pre>");
        }
        sb.append("</center></body></html>");
        if (!(e instanceof NothingToPreviewException)) {
            log.error((Object)("Could not build preview for missing blob at " + xpath), (Throwable)e);
        }
        res.setEntity(sb.toString(), MediaType.TEXT_HTML);
        HttpServletResponse response = PreviewRestlet.getHttpResponse((Response)res);
        response.setHeader("Content-Disposition", "inline");
    }
}

