/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.api.ui;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.api.ui.AbstractDirectoryUIDeleteConstraint;

public class HierarchicalDirectoryUIDeleteConstraint
extends AbstractDirectoryUIDeleteConstraint {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(HierarchicalDirectoryUIDeleteConstraint.class);
    protected String targetDirectory;
    protected String targetDirectoryField;

    public void setProperties(Map<String, String> properties) {
        String targetDirKey = "targetDirectory";
        String targetDirFieldKey = "targetDirectoryField";
        if (properties == null) {
            throw new DirectoryException(String.format("This delete constraint requires properties '%s' and '%s'", targetDirKey, targetDirFieldKey));
        }
        if (!properties.containsKey(targetDirKey)) {
            throw new DirectoryException(String.format("This delete constraint requires property '%s'", targetDirKey));
        }
        if (!properties.containsKey(targetDirFieldKey)) {
            throw new DirectoryException(String.format("This delete constraint requires property '%s'", targetDirFieldKey));
        }
        this.targetDirectory = properties.get(targetDirKey);
        this.targetDirectoryField = properties.get(targetDirFieldKey);
    }

    public boolean canDelete(DirectoryService dirService, String entryId) {
        try (Session dirSession = dirService.open(this.targetDirectory);){
            HashMap<String, String> filter = new HashMap<String, String>();
            filter.put(this.targetDirectoryField, entryId);
            DocumentModelList res = dirSession.query(filter);
            if (res.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Can not delete " + this.targetDirectory + " " + entryId + ", constraint on " + this.targetDirectoryField + ":" + ((DocumentModel)res.get(0)).getId()));
            }
            boolean bl = false;
            return bl;
        }
    }
}

