/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.seam.operations;

import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.jsf.OperationHelper;
import org.nuxeo.ecm.automation.seam.operations.SeamOperationFilter;

@Operation(id="Seam.RunOperation", category="User Interface", label="Run operation in Seam Context", description="Initialize a Seam context (including Conversation if needed) and runs an Operation", aliases={"WebUI.RunOperationInSeam"})
public class RunOperationInSeam {
    public static final String ID = "Seam.RunOperation";
    @Context
    protected OperationContext ctx;
    @Param(name="conversationId", required=false)
    protected String conversationId;
    @Context
    protected AutomationService service;
    @Param(name="id")
    protected String chainId;
    @Param(name="isolate", required=false, values={"false"})
    protected boolean isolate = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OperationMethod
    public Object run() throws OperationException {
        try (OperationContext subctx = this.ctx.getSubContext(this.isolate);){
            if (!OperationHelper.isSeamContextAvailable()) {
                SeamOperationFilter.handleBeforeRun(this.ctx, this.conversationId);
                try {
                    Object object = this.runChain(subctx);
                    return object;
                }
                finally {
                    SeamOperationFilter.handleAfterRun(this.ctx, this.conversationId);
                }
            }
            Object object = this.runChain(subctx);
            return object;
        }
    }

    protected Object runChain(OperationContext subctx) throws OperationException {
        return this.service.run(subctx, this.chainId.startsWith("Chain.") ? this.chainId.substring(6) : this.chainId);
    }
}

