/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.tree.nav;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nuxeo.ecm.webapp.directory.DirectoryTreeDescriptor;
import org.nuxeo.ecm.webapp.directory.DirectoryTreeService;
import org.nuxeo.ecm.webapp.tree.nav.NavTreeDescriptor;
import org.nuxeo.runtime.model.SimpleContributionRegistry;

public class NavTreeRegistry
extends SimpleContributionRegistry<NavTreeDescriptor> {
    public String getContributionId(NavTreeDescriptor contrib) {
        return contrib.getTreeId();
    }

    public void contributionUpdated(String id, NavTreeDescriptor contrib, NavTreeDescriptor newOrigContrib) {
        if (this.currentContribs.containsKey(id)) {
            this.currentContribs.remove(id);
        }
        if (contrib.isEnabled()) {
            this.currentContribs.put(id, contrib);
        }
    }

    public List<NavTreeDescriptor> getTreeDescriptors(DirectoryTreeService directoryTreeService) {
        ArrayList<NavTreeDescriptor> allTrees = new ArrayList<NavTreeDescriptor>();
        allTrees.addAll(this.currentContribs.values());
        List<NavTreeDescriptor> directoryTrees = this.getDirectoryTrees(directoryTreeService);
        if (directoryTrees != null) {
            allTrees.addAll(directoryTrees);
        }
        Collections.sort(allTrees);
        return allTrees;
    }

    protected List<NavTreeDescriptor> getDirectoryTrees(DirectoryTreeService directoryTreeService) {
        if (directoryTreeService == null) {
            return null;
        }
        List<String> treeNames = directoryTreeService.getNavigationDirectoryTrees();
        ArrayList<NavTreeDescriptor> trees = new ArrayList<NavTreeDescriptor>();
        for (String dTreeName : treeNames) {
            DirectoryTreeDescriptor desc = directoryTreeService.getDirectoryTreeDescriptor(dTreeName);
            trees.add(new NavTreeDescriptor(dTreeName, desc.getLabel(), true));
        }
        return trees;
    }
}

