/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.task.live.commands;

import java.io.File;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.task.Command;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.task.live.commands.Deploy;
import org.nuxeo.connect.update.task.standalone.commands.UndeployPlaceholder;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.reload.ReloadService;
import org.osgi.framework.BundleException;

public class Undeploy
extends UndeployPlaceholder {
    private static final Log log = LogFactory.getLog(Undeploy.class);

    public Undeploy() {
    }

    public Undeploy(File file) {
        super(file);
    }

    protected void undeployFile(File file, ReloadService service) throws PackageException {
        String name = service.getOSGIBundleName(file);
        if (name == null) {
            return;
        }
        try {
            service.undeployBundle(file, true);
        }
        catch (BundleException e) {
            throw new PackageException("Failed to undeploy bundle " + file, (Throwable)e);
        }
    }

    protected void undeployDirectory(File dir, ReloadService service) throws PackageException {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File fileInDir : files) {
                this.undeployFile(fileInDir, service);
            }
        }
    }

    protected Command doRun(Task task, Map<String, String> prefs) throws PackageException {
        if (!this.file.exists()) {
            log.warn((Object)("Can't undeploy file " + this.file + ". File is missing."));
            return null;
        }
        try {
            ReloadService srv = (ReloadService)Framework.getLocalService(ReloadService.class);
            if (this.file.isDirectory()) {
                this.undeployDirectory(this.file, srv);
            } else {
                this.undeployFile(this.file, srv);
            }
        }
        catch (PackageException e) {
            task.setRestartRequired(true);
            throw new PackageException("Failed to undeploy bundle " + this.file, (Throwable)e);
        }
        return new Deploy(this.file);
    }
}

