/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.mapping.forward.impl;

import java.math.BigInteger;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import yarfraw.core.datamodel.CategorySubject;
import yarfraw.core.datamodel.ChannelFeed;
import yarfraw.core.datamodel.FeedFormat;
import yarfraw.core.datamodel.Image;
import yarfraw.core.datamodel.ItemEntry;
import yarfraw.core.datamodel.TextInput;
import yarfraw.generated.rss10.elements.DcType;
import yarfraw.generated.rss10.elements.Items;
import yarfraw.generated.rss10.elements.Li;
import yarfraw.generated.rss10.elements.ObjectFactory;
import yarfraw.generated.rss10.elements.Seq;
import yarfraw.generated.rss10.elements.TRss10Channel;
import yarfraw.generated.rss10.elements.TRss10Image;
import yarfraw.generated.rss10.elements.TRss10TextInput;
import yarfraw.generated.rss10.elements.UpdatePeriodEnum;
import yarfraw.mapping.forward.impl.Utils;
import yarfraw.utils.CommonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Rss10MappingUtils {
    private static final ObjectFactory FACTORY = new ObjectFactory();
    private static final Log LOG = LogFactory.getLog(Rss10MappingUtils.class);

    private Rss10MappingUtils() {
    }

    public static JAXBElement<TRss10Image> toRss10Image(Image in) {
        TRss10Image ret = FACTORY.createTRss10Image();
        if (in.getDescription() != null || in.getHeight() != null || in.getWidth() != null) {
            LOG.info((Object)"description, height, width are not supported in Rss 1.0's image element. They will be ignored");
        }
        ret.setTitle(in.getTitle());
        ret.setUrl(in.getUrl());
        ret.setLink(in.getLink());
        ret.setAbout(in.getAbout());
        ret.setResource(in.getResource());
        if (ret.getAbout() == null) {
            ret.setAbout(in.getUrl());
        }
        return FACTORY.createTRss10ChannelImage(ret);
    }

    public static JAXBElement<TRss10TextInput> toRss10TextInput(TextInput in) {
        TRss10TextInput ret = FACTORY.createTRss10TextInput();
        List<Object> elementList = ret.getTitleOrDescriptionOrName();
        if (in.getTitle() != null) {
            elementList.add(FACTORY.createTRss10TextInputTitle(in.getTitle()));
        }
        if (in.getDescription() != null) {
            elementList.add(FACTORY.createTRss10TextInputDescription(in.getDescription()));
        }
        if (in.getName() != null) {
            elementList.add(FACTORY.createTRss10TextInputName(in.getName()));
        }
        if (in.getLink() != null) {
            elementList.add(FACTORY.createTRss10TextInputLink(in.getLink()));
        }
        if (in.getOtherElements() != null) {
            elementList.addAll(in.getOtherElements());
        }
        ret.setAbout(in.getAbout());
        ret.setResource(in.getResource());
        if (ret.getAbout() == null) {
            ret.setAbout(in.getLink());
        }
        return FACTORY.createTextinput(ret);
    }

    public static JAXBElement<TRss10Channel> toChannel(ChannelFeed ch) {
        String contributor;
        String publisher;
        DcType dc;
        String creator;
        DcType dc2;
        String link;
        ObjectFactory factory = FACTORY;
        TRss10Channel ret = factory.createTRss10Channel();
        List<Object> elementList = ret.getTitleOrLinkOrDescription();
        if (ch.getTitleText() != null) {
            elementList.add(factory.createTRss10ChannelTitle(ch.getTitleText()));
        }
        if ((link = Utils.getHrefLink(ch.getLinks())) != null) {
            elementList.add(factory.createTRss10ChannelLink(link));
        }
        if (ch.getDescriptionOrSubtitleText() != null) {
            elementList.add(factory.createTRss10ChannelDescription(ch.getDescriptionOrSubtitleText()));
        }
        if (ch.getImageOrIcon() != null) {
            TRss10Image img = factory.createTRss10Image();
            img.setResource(ch.getImageOrIcon().getAbout());
            if (img.getResource() == null) {
                img.setAbout(img.getUrl());
            }
            elementList.add(factory.createTRss10ChannelImage(img));
        }
        if (ch.getTexInput() != null) {
            TRss10TextInput ti = factory.createTRss10TextInput();
            ti.setResource(ch.getTexInput().getAbout());
            if (ti.getResource() == null) {
                ti.setResource(ch.getTexInput().getLink());
            }
            elementList.add(factory.createTextinput(ti));
        }
        if (ch.getCategorySubjects() != null) {
            for (CategorySubject c : ch.getCategorySubjects()) {
                if (c == null) continue;
                dc2 = new DcType();
                dc2.setValue(c.getCategoryOrSubjectOrTerm());
                elementList.add(factory.createSubject(dc2));
            }
        }
        if (ch.getCloud() != null) {
            LOG.info((Object)"Channel.Cloud is not supported in Rss 1.0 feed. It will be ignored.");
        }
        if (ch.getRightsText() != null) {
            DcType dc3 = new DcType();
            dc3.setValue(ch.getRightsText());
            elementList.add(factory.createRights(dc3));
        }
        if (ch.getDocs() != null) {
            LOG.info((Object)"Channel.Docs is not supported in Rss 1.0 feed. It will be ignored.");
        }
        if (ch.getGenerator() != null) {
            LOG.info((Object)"Channel.Generator is not supported in Rss 1.0 feed. It will be ignored.");
        }
        Seq seq = factory.createSeq();
        if (ch.getItems() != null) {
            for (ItemEntry t : ch.getItems()) {
                if (t == null) continue;
                Li li = factory.createLi();
                if (t.getResource() != null) {
                    li.setResource(t.getResource());
                } else if (CollectionUtils.isNotEmpty(t.getLinks())) {
                    li.setResource(t.getLinks().get(0).getHref());
                } else {
                    LOG.warn((Object)"no <link> found under Item, unable to create <li> element under <items>");
                }
                seq.getLi().add(li);
            }
        }
        Items items = factory.createItems();
        items.setSeq(seq);
        elementList.add(factory.createItems(items));
        if (ch.getLang() != null) {
            dc2 = new DcType();
            dc2.setValue(ch.getLang());
            elementList.add(factory.createLanguage(dc2));
        }
        if (ch.getLastBuildOrUpdatedDate() != null) {
            LOG.info((Object)"Channel.LastBuildDate is not supported in Rss 1.0 feed. It will be ignored.");
        }
        if ((creator = Utils.getEmailOrText(ch.getWebMasterOrCreator())) != null) {
            DcType dc4 = new DcType();
            dc4.setValue(creator);
            elementList.add(factory.createCreator(dc4));
        }
        if (ch.getPubDate() != null) {
            String dateString = ch.getPubDate();
            if (!CommonUtils.isDateFormatValid(dateString, FeedFormat.RSS10)) {
                String newDateString = CommonUtils.formatDate(CommonUtils.tryParseDate(dateString), FeedFormat.RSS10);
                if (newDateString != null) {
                    dateString = newDateString;
                } else {
                    LOG.warn((Object)("The dateString " + dateString + " is in valid according to RSS 1.0 specs, unabel to convert it to a valid format, writing it as is"));
                }
            }
            dc = new DcType();
            dc.setValue(dateString);
            elementList.add(factory.createDate(dc));
        }
        if (ch.getSkipDays() != null) {
            LOG.info((Object)"Channel.SkipDays is not supported in Rss 1.0 feed. It will be ignored.");
        }
        if (ch.getSkipHours() != null) {
            LOG.info((Object)"Channel.SkipHours is not supported in Rss 1.0 feed. It will be ignored.");
        }
        if (ch.getTtl() != null) {
            int ttl = ch.getTtl();
            UpdatePeriodEnum updatedPeriod = UpdatePeriodEnum.DAILY;
            int frequency = 1;
            if (ttl < 60) {
                updatedPeriod = UpdatePeriodEnum.HOURLY;
                frequency = Math.max(1, 60 / ttl);
            } else if (ttl < 1440) {
                frequency = Math.max(1, 1440 / ttl);
            } else if (ttl < 10080) {
                updatedPeriod = UpdatePeriodEnum.WEEKLY;
                frequency = Math.max(1, 10080 / ttl);
            } else if (ttl < 43200) {
                updatedPeriod = UpdatePeriodEnum.MONTHLY;
                frequency = Math.max(1, 43200 / ttl);
            } else {
                updatedPeriod = UpdatePeriodEnum.YEARLY;
                frequency = Math.max(1, 525600 / ttl);
            }
            elementList.add(factory.createUpdatePeriod(updatedPeriod));
            elementList.add(factory.createUpdateFrequency(new BigInteger(String.valueOf(frequency))));
        }
        if ((publisher = Utils.getEmailOrText(ch.getManagingEditorOrAuthorOrPublisher())) != null) {
            dc = new DcType();
            dc.setValue(publisher);
            elementList.add(factory.createPublisher(dc));
        }
        if ((contributor = Utils.getEmailOrText(ch.getContributors())) != null) {
            DcType dc5 = new DcType();
            dc5.setValue(contributor);
            elementList.add(factory.createContributor(dc5));
        }
        ret.setAbout(ch.getAbout());
        ret.setResource(ch.getResource());
        if (ret.getAbout() == null) {
            ret.setAbout(Utils.getHrefLink(ch.getLinks()));
        }
        if (ch.getOtherElements() != null) {
            elementList.addAll(ch.getOtherElements());
        }
        if (ch.getOtherAttributes() != null) {
            ret.getOtherAttributes().putAll(ch.getOtherAttributes());
        }
        return factory.createChannel(ret);
    }
}

