/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import yarfraw.core.datamodel.ValidationException;

public class ValidationUtils {
    private static final Pattern EMAIL = Pattern.compile("^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*$", 2);

    private ValidationUtils() {
    }

    public static void validateNotNull(String message, Object ... o) throws ValidationException {
        if (!ArrayUtils.isEmpty((Object[])o)) {
            for (Object oo : o) {
                if (oo != null) continue;
                throw new ValidationException(message);
            }
        }
    }

    public static void validateUri(String message, String ... uri) throws ValidationException {
        if (!ArrayUtils.isEmpty((Object[])uri)) {
            for (String s : uri) {
                if (s == null) continue;
                try {
                    URI u = new URI(s);
                }
                catch (URISyntaxException e) {
                    throw new ValidationException(message, e);
                }
            }
        }
    }

    public static void validateEmails(String message, String ... emails) throws ValidationException {
        if (!ArrayUtils.isEmpty((Object[])emails)) {
            for (String email : emails) {
                Matcher m;
                if (email == null || (m = EMAIL.matcher(email)).matches()) continue;
                throw new ValidationException(message);
            }
        }
    }
}

