/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.util;

import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ComponentTagUtils {
    private static final Log log = LogFactory.getLog(ComponentTagUtils.class);

    private ComponentTagUtils() {
    }

    public static boolean isValueReference(String value) {
        if (value == null) {
            return false;
        }
        return value.contains("#{") && value.indexOf("#{") < value.indexOf(125) || value.contains("${") && value.indexOf("${") < value.indexOf(125);
    }

    public static boolean isStrictValueReference(String value) {
        if (value == null) {
            return false;
        }
        return (value = value.trim()).startsWith("#{") && value.indexOf("#{") < value.indexOf(125) && value.endsWith("}") || value.startsWith("${") && value.indexOf("${") < value.indexOf(125) && value.endsWith("}");
    }

    public static String getBareValueName(String valueReference) {
        if (!ComponentTagUtils.isStrictValueReference(valueReference)) {
            throw new IllegalArgumentException("Invalid value reference '" + valueReference + "'");
        }
        return valueReference.substring(2, valueReference.length() - 1);
    }

    @Deprecated
    public static boolean isMethodReference(String value) {
        boolean isValue = ComponentTagUtils.isValueReference(value);
        return isValue && value.contains("(") && value.indexOf(40) < value.indexOf(41) && (!value.contains(":") || value.indexOf(58) > value.indexOf(40));
    }

    public static Object resolveElExpression(FacesContext context, String elExpression) {
        if (!ComponentTagUtils.isValueReference(elExpression)) {
            return elExpression;
        }
        if (context == null) {
            log.error((Object)("FacesContext is null => cannot resolve el expression '" + elExpression + "'"));
            return null;
        }
        Application app = context.getApplication();
        try {
            return app.evaluateExpressionGet(context, elExpression, Object.class);
        }
        catch (ELException e) {
            log.error((Object)("Faces context: Error processing expression '" + elExpression + "'"), (Throwable)e);
            return null;
        }
    }

    public static void applyValueExpression(FacesContext context, String elExpression, Object value) {
        if (!ComponentTagUtils.isStrictValueReference(elExpression)) {
            log.warn((Object)("Cannot set value '" + value + "' for expression '" + elExpression + "'"));
        } else {
            if (context == null) {
                log.error((Object)("FacesContext is null => cannot resolve el expression '" + elExpression + "'"));
                return;
            }
            Application app = context.getApplication();
            ExpressionFactory eFactory = app.getExpressionFactory();
            ELContext elContext = context.getELContext();
            try {
                ValueExpression vExpression = eFactory.createValueExpression(elContext, elExpression, Object.class);
                vExpression.setValue(elContext, value);
            }
            catch (ELException e) {
                log.error((Object)("Error setting value '" + value + "' for expression '" + elExpression + "'"), (Throwable)e);
            }
        }
    }

    public static Object resolveElExpression(FaceletContext faceletContext, String elExpression) {
        if (!ComponentTagUtils.isValueReference(elExpression)) {
            return elExpression;
        }
        if (faceletContext == null) {
            log.error((Object)("FaceletContext is null => cannot resolve el expression '" + elExpression + "'"));
            return null;
        }
        ExpressionFactory eFactory = faceletContext.getExpressionFactory();
        ELContext elContext = faceletContext.getFacesContext().getELContext();
        ValueExpression expr = eFactory.createValueExpression((ELContext)faceletContext, elExpression, Object.class);
        try {
            return expr.getValue(elContext);
        }
        catch (ELException e) {
            log.error((Object)("Facelet context: Error processing expression '" + elExpression + "'"), (Throwable)e);
            return null;
        }
    }
}

