/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import com.sun.faces.facelets.el.VariableMapperWrapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.MetaTagHandler;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.el.ValueExpressionLiteral;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;
import org.nuxeo.ecm.platform.forms.layout.facelets.WidgetTypeHandler;
import org.nuxeo.ecm.platform.forms.layout.facelets.dev.DevTagHandler;
import org.nuxeo.ecm.platform.forms.layout.service.WebLayoutManager;
import org.nuxeo.ecm.platform.ui.web.binding.BlockingVariableMapper;
import org.nuxeo.ecm.platform.ui.web.tag.handler.TagConfigFactory;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;
import org.nuxeo.ecm.platform.ui.web.util.FaceletDebugTracer;
import org.nuxeo.runtime.api.Framework;

public class WidgetTagHandler
extends MetaTagHandler {
    private static final Log log = LogFactory.getLog(WidgetTagHandler.class);
    protected final TagConfig config;
    protected final TagAttribute widget;
    protected final TagAttribute name;
    protected final TagAttribute category;
    protected final TagAttribute definition;
    protected final TagAttribute mode;
    protected final TagAttribute layoutName;
    protected final TagAttribute resolveOnly;
    protected final TagAttribute value;
    protected final TagAttribute[] vars;
    protected final String[] reservedVarsArray = new String[]{"id", "widget", "name", "category", "definition", "mode", "layoutName", "value", "resolveOnly"};

    public WidgetTagHandler(TagConfig config) {
        super(config);
        this.config = config;
        this.widget = this.getAttribute("widget");
        this.name = this.getAttribute("name");
        this.definition = this.getAttribute("definition");
        this.category = this.getAttribute("category");
        this.mode = this.getAttribute("mode");
        this.layoutName = this.getAttribute("layoutName");
        this.resolveOnly = this.getAttribute("resolveOnly");
        this.value = this.getAttribute("value");
        this.vars = this.tag.getAttributes().getAll();
        if (this.name == null && this.widget == null && this.definition == null) {
            throw new TagException(this.tag, "At least one of attributes 'name', 'widget' or 'definition' is required");
        }
        if (this.widget == null && (this.name != null || this.definition != null) && this.mode == null) {
            throw new TagException(this.tag, "Attribute 'mode' is required when using attribute 'name' or 'definition' so that the widget instance can be resolved");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, ELException {
        Widget widgetInstance;
        long start;
        block22: {
            start = FaceletDebugTracer.start();
            widgetInstance = null;
            try {
                String valueName = null;
                if (this.value != null) {
                    valueName = this.value.getValue();
                }
                if (ComponentTagUtils.isStrictValueReference(valueName)) {
                    valueName = ComponentTagUtils.getBareValueName((String)valueName);
                }
                boolean widgetInstanceBuilt = false;
                if (this.widget != null) {
                    widgetInstance = (Widget)this.widget.getObject(ctx, Widget.class);
                    if (widgetInstance != null && valueName != null) {
                        widgetInstance.setValueName(valueName);
                    }
                } else {
                    WidgetDefinition widgetDef;
                    WebLayoutManager layoutService = (WebLayoutManager)Framework.getService(WebLayoutManager.class);
                    String modeValue = this.mode.getValue(ctx);
                    TagAttribute[] layoutNameValue = null;
                    if (this.layoutName != null) {
                        layoutNameValue = this.layoutName.getValue(ctx);
                    }
                    if (this.name != null) {
                        String nameValue = this.name.getValue(ctx);
                        String catValue = null;
                        if (this.category != null) {
                            catValue = this.category.getValue(ctx);
                        }
                        widgetInstance = layoutService.getWidget(ctx, nameValue, catValue, modeValue, valueName, (String)layoutNameValue);
                        widgetInstanceBuilt = true;
                    } else if (this.definition != null && (widgetDef = (WidgetDefinition)this.definition.getObject(ctx, WidgetDefinition.class)) != null) {
                        widgetInstance = layoutService.getWidget(ctx, widgetDef, modeValue, valueName, (String)layoutNameValue);
                        widgetInstanceBuilt = true;
                    }
                }
                if (widgetInstance == null) break block22;
                String widgetPropertyMarker = RenderVariables.widgetVariables.widgetProperty.name() + "_";
                List<String> reservedVars = Arrays.asList(this.reservedVarsArray);
                for (TagAttribute var : this.vars) {
                    String localName = var.getLocalName();
                    if (reservedVars.contains(localName)) continue;
                    if (localName != null && localName.startsWith(widgetPropertyMarker)) {
                        localName = localName.substring(widgetPropertyMarker.length());
                    }
                    widgetInstance.setProperty(localName, (Serializable)((Object)var.getValue()));
                }
                VariableMapper orig = ctx.getVariableMapper();
                try {
                    if (FaceletHandlerHelper.isAliasOptimEnabled()) {
                        this.applyOptimized(ctx, orig, widgetInstance, widgetInstanceBuilt);
                    } else {
                        this.applyCompat(ctx, orig, widgetInstance, widgetInstanceBuilt);
                    }
                    boolean resolveOnlyBool = false;
                    if (this.resolveOnly != null) {
                        resolveOnlyBool = this.resolveOnly.getBoolean(ctx);
                    }
                    if (resolveOnlyBool) {
                        this.nextHandler.apply(ctx, parent);
                    } else {
                        WidgetTagHandler.applyWidgetHandler(ctx, parent, this.config, widgetInstance, this.value, true, this.nextHandler);
                    }
                }
                finally {
                    ctx.setVariableMapper(orig);
                }
            }
            catch (Throwable throwable) {
                FaceletDebugTracer.trace((long)start, (Tag)this.config.getTag(), (String)(widgetInstance == null ? null : widgetInstance.getId()));
                throw throwable;
            }
        }
        FaceletDebugTracer.trace((long)start, (Tag)this.config.getTag(), (String)(widgetInstance == null ? null : widgetInstance.getId()));
    }

    public static void generateWidgetIdsRecursive(FaceletContext ctx, FaceletHandlerHelper helper, Widget widget) {
        WidgetTagHandler.generateWidgetId(ctx, helper, widget, true);
    }

    public static void generateWidgetId(FaceletContext ctx, FaceletHandlerHelper helper, Widget widget, boolean recursive) {
        Widget[] subWidgets;
        if (widget == null) {
            return;
        }
        widget.setId(FaceletHandlerHelper.generateWidgetId(ctx, widget.getName()));
        if (recursive && (subWidgets = widget.getSubWidgets()) != null) {
            for (Widget subWidget : subWidgets) {
                WidgetTagHandler.generateWidgetIdsRecursive(ctx, helper, subWidget);
            }
        }
    }

    protected void applyOptimized(FaceletContext ctx, VariableMapper orig, Widget widgetInstance, boolean widgetInstanceBuilt) {
        BlockingVariableMapper vm = new BlockingVariableMapper(orig);
        ctx.setVariableMapper((VariableMapper)vm);
        if (widgetInstanceBuilt) {
            FaceletHandlerHelper helper = new FaceletHandlerHelper(this.config);
            WidgetTagHandler.generateWidgetId(ctx, helper, widgetInstance, false);
            WidgetTagHandler.exposeWidgetVariables(ctx, vm, widgetInstance, null, false);
        }
    }

    protected void applyCompat(FaceletContext ctx, VariableMapper orig, Widget widgetInstance, boolean widgetInstanceBuilt) {
        if (!widgetInstanceBuilt) {
            return;
        }
        FaceletHandlerHelper helper = new FaceletHandlerHelper(this.config);
        WidgetTagHandler.generateWidgetId(ctx, helper, widgetInstance, false);
        VariableMapperWrapper vm = new VariableMapperWrapper(orig);
        ctx.setVariableMapper((VariableMapper)vm);
        ExpressionFactory eFactory = ctx.getExpressionFactory();
        ValueExpression widgetVe = eFactory.createValueExpression((Object)widgetInstance, Widget.class);
        vm.setVariable(RenderVariables.widgetVariables.widget.name(), widgetVe);
        for (Map.Entry ctrl : widgetInstance.getControls().entrySet()) {
            String key = (String)ctrl.getKey();
            String name = RenderVariables.widgetVariables.widgetControl.name() + "_" + key;
            String value = "#{" + RenderVariables.widgetVariables.widget.name() + ".controls." + key + "}";
            vm.setVariable(name, eFactory.createValueExpression((ELContext)ctx, value, Object.class));
        }
    }

    public static void applyWidgetHandler(FaceletContext ctx, UIComponent parent, TagConfig config, Widget widget, TagAttribute value, boolean fillVariables, FaceletHandler nextHandler) throws IOException {
        FaceletHandler devHandler;
        if (widget == null) {
            return;
        }
        FaceletHandlerHelper helper = new FaceletHandlerHelper(config);
        TagConfig wtConfig = TagConfigFactory.createTagConfig((TagConfig)config, (String)widget.getTagConfigId(), null, (FaceletHandler)nextHandler);
        WebLayoutManager layoutService = (WebLayoutManager)Framework.getService(WebLayoutManager.class);
        WidgetTypeHandler handler = layoutService.getWidgetTypeHandler(wtConfig, widget);
        if (handler == null) {
            String widgetTypeName = widget.getType();
            String widgetTypeCategory = widget.getTypeCategory();
            String message = String.format("No widget handler found for type '%s' in category '%s'", widgetTypeName, widgetTypeCategory);
            log.error((Object)message);
            ComponentHandler h = helper.getErrorComponentHandler(null, message);
            h.apply(ctx, parent);
            return;
        }
        TagHandler fh = handler;
        if (FaceletHandlerHelper.isDevModeEnabled(ctx) && (devHandler = handler.getDevFaceletHandler(config, widget)) != null) {
            String widgetTagConfigId = widget.getTagConfigId();
            HashMap<String, ValueExpression> variables = new HashMap<String, ValueExpression>();
            ExpressionFactory eFactory = ctx.getExpressionFactory();
            ValueExpression widgetVe = eFactory.createValueExpression((Object)widget, Widget.class);
            variables.put(RenderVariables.widgetVariables.widget.name(), widgetVe);
            ArrayList<String> blockedPatterns = new ArrayList<String>();
            blockedPatterns.add(RenderVariables.widgetVariables.widget.name() + "*");
            FaceletHandler devAliasHandler = helper.getAliasFaceletHandler(widgetTagConfigId, variables, blockedPatterns, devHandler);
            String refId = widget.getName();
            fh = new DevTagHandler(config, refId, (FaceletHandler)handler, devAliasHandler);
        }
        if (FaceletHandlerHelper.isAliasOptimEnabled()) {
            if (fillVariables) {
                VariableMapper cvm = ctx.getVariableMapper();
                if (!(cvm instanceof BlockingVariableMapper)) {
                    throw new IllegalArgumentException("Current context variable mapper should be an instance of MetaVariableMapper");
                }
                BlockingVariableMapper vm = (BlockingVariableMapper)cvm;
                Object valueExpr = value == null ? new ValueExpressionLiteral(null, Object.class) : value.getValueExpression(ctx, Object.class);
                vm.setVariable(RenderVariables.globalVariables.value.name(), valueExpr);
                vm.setVariable(RenderVariables.globalVariables.value.name() + "_" + widget.getLevel(), valueExpr);
            }
            fh.apply(ctx, parent);
        } else if (fillVariables) {
            HashMap<String, ValueExpression> variables = new HashMap<String, ValueExpression>();
            Object valueExpr = value == null ? new ValueExpressionLiteral(null, Object.class) : value.getValueExpression(ctx, Object.class);
            variables.put(RenderVariables.globalVariables.value.name(), (ValueExpression)valueExpr);
            variables.put(RenderVariables.globalVariables.value.name() + "_" + widget.getLevel(), (ValueExpression)valueExpr);
            FaceletHandler handlerWithVars = helper.getAliasFaceletHandler(widget.getTagConfigId(), variables, null, (FaceletHandler)fh);
            handlerWithVars.apply(ctx, parent);
        } else {
            fh.apply(ctx, parent);
        }
    }

    public static void exposeWidgetVariables(FaceletContext ctx, BlockingVariableMapper vm, Widget widget, Integer widgetIndex, boolean exposeLevel) {
        ExpressionFactory eFactory = ctx.getExpressionFactory();
        ValueExpression widgetVe = eFactory.createValueExpression((Object)widget, Widget.class);
        vm.setVariable(RenderVariables.widgetVariables.widget.name(), widgetVe);
        vm.addBlockedPattern(RenderVariables.widgetVariables.widget.name());
        ValueExpression widgetIndexVe = null;
        if (widgetIndex != null) {
            widgetIndexVe = eFactory.createValueExpression((Object)widgetIndex, Integer.class);
            vm.setVariable(RenderVariables.widgetVariables.widgetIndex.name(), widgetIndexVe);
        }
        if (exposeLevel && !FaceletHandlerHelper.isAliasOptimEnabled()) {
            Integer level = null;
            if (widget != null) {
                level = widget.getLevel();
            }
            vm.setVariable(RenderVariables.widgetVariables.widget.name() + "_" + level, widgetVe);
            if (widgetIndexVe != null) {
                vm.setVariable(RenderVariables.widgetVariables.widgetIndex.name() + "_" + level, widgetIndexVe);
            }
            vm.addBlockedPattern(RenderVariables.widgetVariables.widget.name() + "_*");
            vm.addBlockedPattern(RenderVariables.widgetVariables.widgetIndex.name() + "*");
        }
        if (widget != null) {
            for (Map.Entry ctrl : widget.getControls().entrySet()) {
                String key = (String)ctrl.getKey();
                String name = RenderVariables.widgetVariables.widgetControl.name() + "_" + key;
                ValueExpression ve = eFactory.createValueExpression(ctrl.getValue(), Object.class);
                vm.setVariable(name, ve);
            }
        }
        vm.addBlockedPattern(RenderVariables.widgetVariables.widgetControl.name() + "_*");
    }

    protected MetaRuleset createMetaRuleset(Class type) {
        return null;
    }
}

