/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.tree.nav;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Events;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.webapp.action.WebActionsBean;
import org.nuxeo.ecm.webapp.directory.DirectoryTreeManager;

@Name(value="multiNavTreeManager")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class MultiNavTreeManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String STD_NAV_TREE = "CONTENT_TREE";
    protected String thePath = "";
    @In(required=false, create=true)
    protected WebActionsBean webActions;
    @In(required=false, create=true)
    protected DirectoryTreeManager directoryTreeManager;
    @In(create=true)
    protected Map<String, String> messages;

    public void setSelectedNavigationTree(String selectedNavigationTree) {
        this.webActions.setCurrentTabId("TREE_EXPLORER", selectedNavigationTree, new String[0]);
    }

    public String getSelectedNavigationTree() {
        String id = this.webActions.getCurrentTabId("TREE_EXPLORER");
        if (id != null) {
            if (id.startsWith("dirtree_")) {
                return id.substring("dirtree_".length());
            }
            if (id.startsWith("dirtree_")) {
                return id.substring("dirtree_".length());
            }
            return id;
        }
        return null;
    }

    @Observer(value={"currentTabChanged_TREE_EXPLORER", "currentTabChanged_DIRECTORY_TREE_EXPLORER"}, create=true)
    public void onCurrentTreeChange(String category, String tabId) {
        Events.instance().raiseEvent("folderishDocumentSelectionChanged", new Object[]{new DocumentModelImpl("Folder")});
        if (tabId != null) {
            if (tabId.startsWith("dirtree_")) {
                this.directoryTreeManager.setSelectedTreeName(tabId.substring("dirtree_".length()));
            }
            if (tabId.startsWith("DIRECTORY_TREE_EXPLORER")) {
                this.directoryTreeManager.setSelectedTreeName(tabId.substring("DIRECTORY_TREE_EXPLORER".length()));
            }
        }
    }

    @Observer(value={"PATH_PROCESSED"}, create=false)
    @BypassInterceptors
    public void setThePath(String myPath) {
        this.thePath = myPath;
    }

    public String getVirtualNavPath() {
        String[] partOfPath = this.thePath.split("/");
        String finalPath = "";
        for (String aPart : partOfPath) {
            if (StringUtils.isBlank((String)aPart)) continue;
            finalPath = finalPath + " > " + this.messages.get(aPart);
        }
        return finalPath;
    }
}

