/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.document;

import com.lowagie.text.DocWriter;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.document.RtfInfoElement;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class RtfInfoGroup
extends RtfElement {
    private static final byte[] INFO_GROUP = DocWriter.getISOBytes((String)"\\info");
    private static final byte[] INFO_PASSWORD = DocWriter.getISOBytes((String)"\\*\\password");
    ArrayList infoElements = new ArrayList();

    public RtfInfoGroup(RtfDocument rtfDocument) {
        super(rtfDocument);
    }

    public void add(RtfInfoElement rtfInfoElement) {
        this.infoElements.add(rtfInfoElement);
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        outputStream.write(OPEN_GROUP);
        outputStream.write(INFO_GROUP);
        for (int i = 0; i < this.infoElements.size(); ++i) {
            RtfInfoElement rtfInfoElement = (RtfInfoElement)this.infoElements.get(i);
            rtfInfoElement.writeContent(outputStream);
        }
        if (this.document.getDocumentSettings().isDocumentProtected()) {
            outputStream.write(OPEN_GROUP);
            outputStream.write(INFO_PASSWORD);
            outputStream.write(DELIMITER);
            outputStream.write(this.document.getDocumentSettings().getProtectionHashBytes());
            outputStream.write(CLOSE_GROUP);
        }
        outputStream.write(CLOSE_GROUP);
        this.document.outputDebugLinebreak(outputStream);
    }
}

