/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.webapp;

import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.webapp.PushServletContainerInitializer;
import org.richfaces.webapp.ResourceServletContainerInitializer;

public class ServletsInitializer
implements ServletContainerInitializer {
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private Class<?>[] INITIALIZERS = new Class[]{PushServletContainerInitializer.class, ResourceServletContainerInitializer.class};

    public void onStartup(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
        for (Class<?> clazz : this.INITIALIZERS) {
            ServletContainerInitializer initializer = null;
            try {
                initializer = (ServletContainerInitializer)clazz.newInstance();
            }
            catch (Exception e) {
                LOGGER.error("Failed to instantiate servlet initializer " + clazz.getName(), e);
            }
            if (initializer == null) continue;
            try {
                initializer.onStartup(null, servletContext);
            }
            catch (Exception e) {
                LOGGER.error("Failed to initialize servlet by " + clazz.getName(), e);
            }
        }
    }
}

