/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;

@Name(value="authorizedApplicationsActions")
@Scope(value=ScopeType.CONVERSATION)
public class AuthorizedApplicationsActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In
    protected NuxeoPrincipal currentUser;

    public List<DocumentModel> getAuthorizedApplications() {
        DirectoryService directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = directoryService.open("oauthTokens");){
            Map<String, Serializable> queryFilter = this.getQueryFilter();
            Set emptySet = Collections.emptySet();
            DocumentModelList documentModelList = session.query(queryFilter, emptySet, null, true);
            return documentModelList;
        }
    }

    protected Map<String, Serializable> getQueryFilter() {
        HashMap<String, Serializable> filter = new HashMap<String, Serializable>();
        filter.put("clientToken", new Integer(0));
        filter.put("nuxeoLogin", (Serializable)((Object)this.currentUser.getName()));
        return filter;
    }

    public void revokeAccess(String id) {
        DirectoryService directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = directoryService.open("oauthTokens");){
            session.deleteEntry(id);
        }
    }
}

