/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.helpers;

import java.io.Serializable;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.core.Manager;

@Startup
@Name(value="conversationIdGenerator")
@Scope(value=ScopeType.SESSION)
public class ConversationIdGenerator
implements Serializable {
    private static final long serialVersionUID = 15643987456876L;
    private static final String MAIN_CONVERSATION_PREFIX = "0NXMAIN";
    private static final String CREATE_CONVERSATION_PREFIX = "0NXCREATE";
    private int mainConversationCounter = 0;
    private int createConversationCounter = 0;
    @In(value="org.jboss.seam.core.manager")
    public transient Manager conversationManager;

    public String getNextMainConversationId() {
        String newMainConversationId = this.mainConversationCounter == 0 ? MAIN_CONVERSATION_PREFIX : MAIN_CONVERSATION_PREFIX + this.mainConversationCounter;
        ++this.mainConversationCounter;
        return newMainConversationId;
    }

    public String getNextCreateConversationId() {
        String newCreateConversationId = this.createConversationCounter == 0 ? CREATE_CONVERSATION_PREFIX : CREATE_CONVERSATION_PREFIX + this.createConversationCounter;
        ++this.createConversationCounter;
        return newCreateConversationId;
    }

    public String getCurrentOrNewMainConversationId() {
        String existingConversationId = this.getConversationIdInURL();
        if (existingConversationId != null && existingConversationId.startsWith(MAIN_CONVERSATION_PREFIX)) {
            return existingConversationId;
        }
        if (this.conversationManager.isReallyLongRunningConversation()) {
            existingConversationId = this.conversationManager.getCurrentConversationId();
            if (existingConversationId.startsWith(MAIN_CONVERSATION_PREFIX)) {
                return existingConversationId;
            }
            return this.getNextMainConversationId();
        }
        return this.getNextMainConversationId();
    }

    protected String getConversationIdInURL() {
        String conversationIdInUrl;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            return null;
        }
        Map rMap = facesContext.getExternalContext().getRequestMap();
        if (rMap.containsKey(this.conversationManager.getConversationIdParameter())) {
            conversationIdInUrl = (String)rMap.get(this.conversationManager.getConversationIdParameter());
        } else {
            Map pMap = facesContext.getExternalContext().getRequestParameterMap();
            if (pMap.containsKey(this.conversationManager.getConversationIdParameter())) {
                conversationIdInUrl = (String)pMap.get(this.conversationManager.getConversationIdParameter());
            } else {
                return null;
            }
        }
        return conversationIdInUrl;
    }
}

