/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.excel;

import java.util.HashMap;
import java.util.Map;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.excel.ExcelWorkbook;
import org.jboss.seam.excel.csv.CsvExcelWorkbook;
import org.jboss.seam.excel.jxl.JXLExcelWorkbook;
import org.jboss.seam.util.Strings;

@Name(value="org.jboss.seam.excel.excelFactory")
@Scope(value=ScopeType.STATELESS)
@AutoCreate
@Install(precedence=0)
@BypassInterceptors
public class ExcelFactory {
    private static Map<String, Class<? extends ExcelWorkbook>> defaultImplementations = new HashMap<String, Class<? extends ExcelWorkbook>>();
    private Map<String, Class> implementations;

    public static ExcelFactory instance() {
        return (ExcelFactory)Component.getInstance(ExcelFactory.class);
    }

    public ExcelWorkbook getExcelWorkbook(String type) {
        ExcelWorkbook excelWorkbook;
        Class clazz;
        if (Strings.isEmpty((String)type)) {
            type = "jxl";
        }
        if ((clazz = this.implementations != null && this.implementations.get(type) != null ? this.implementations.get(type) : defaultImplementations.get(type)) == null) {
            throw new IllegalArgumentException("Unable to create workbook of type " + type);
        }
        try {
            excelWorkbook = clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The class provided could not be instanciated " + type, e);
        }
        return excelWorkbook;
    }

    public Map<String, Class> getImplementations() {
        return this.implementations;
    }

    public void setImplementations(Map<String, Class> implementations) {
        this.implementations = implementations;
    }

    static {
        defaultImplementations.put("csv", CsvExcelWorkbook.class);
        defaultImplementations.put("jxl", JXLExcelWorkbook.class);
    }
}

