/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.helpers;

import java.io.Serializable;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.util.DocumentLocator;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.ecm.webapp.helpers.ConversationIdGenerator;

@Startup
@Name(value="paralleleNavigationHelper")
@Scope(value=ScopeType.SESSION)
public class ParalleleNavigationHelper
implements Serializable {
    private static final long serialVersionUID = 16794309876876L;
    public static final String PARALLELE_URL_PREFIX = "/parallele.faces?";
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    ConversationIdGenerator conversationIdGenerator;
    @RequestParameter
    String docRef;

    @Begin(id="#{conversationIdGenerator.nextMainConversationId}")
    public String navigateToURL() {
        if (this.docRef == null) {
            return null;
        }
        return this.navigationContext.navigateToURL(this.docRef);
    }

    public String getCurrentDocumentFullUrl() {
        String internalURL = this.navigationContext.getCurrentDocumentFullUrl();
        return internalURL.replace("getDocument.faces?", PARALLELE_URL_PREFIX);
    }

    public String getDocumentFullUrl(DocumentRef docRef) {
        String internalURL = DocumentLocator.getFullDocumentUrl((RepositoryLocation)this.navigationContext.getCurrentServerLocation(), (DocumentRef)docRef);
        return internalURL.replace("getDocument.faces?", PARALLELE_URL_PREFIX);
    }
}

