/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jsf.operations;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.jsf.OperationHelper;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsPersistenceManager;

@Operation(id="Seam.GetDocumentsFromSelectionList", category="Fetch", requires="Seam", label="UI Selected documents from list", description="Fetch the documents selected in the selection list passed as a parameter. If the list name is empty, the current folder selection list is used.")
public class GetDocumentsFromSelectionList {
    public static final String ID = "Seam.GetDocumentsFromSelectionList";
    @Context
    protected OperationContext ctx;
    @Param(name="listName", required=false)
    protected String listName;

    @OperationMethod
    public DocumentModelList run() throws OperationException {
        String workingListName = this.listName;
        if (StringUtils.isEmpty((String)workingListName)) {
            workingListName = "CURRENT_SELECTION";
        }
        List res = null;
        if (OperationHelper.isSeamContextAvailable()) {
            res = OperationHelper.getDocumentListManager().getWorkingList(workingListName);
        } else if (OperationHelper.getDocumentListManager().getWorkingListDescriptor(workingListName).getPersistent()) {
            DocumentsListsPersistenceManager pm = new DocumentsListsPersistenceManager();
            res = pm.loadPersistentDocumentsLists(this.ctx.getCoreSession(), this.ctx.getPrincipal().getName(), workingListName);
        } else {
            throw new OperationException(String.format("Cannot get selected documents from selection list '%s' because the Seam context is not available and this list is not persisted.", workingListName));
        }
        return new DocumentModelListImpl(res);
    }
}

