/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.l10n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.richfaces.l10n.BundleLoader;
import org.richfaces.l10n.InterpolationException;

public class MessageInterpolator {
    private BundleLoader bundleLoader;

    public MessageInterpolator(BundleLoader bundleLoader) {
        this.bundleLoader = bundleLoader;
    }

    protected String getMessageKey(Enum<?> key) {
        return key.toString();
    }

    protected String getPattern(Locale locale, Enum<?> key) {
        String messageKey = this.getMessageKey(key);
        try {
            ResourceBundle bundle = this.bundleLoader.getBundle(key, locale);
            return bundle.getString(messageKey);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public String interpolate(Locale locale, Enum<?> key, Object ... args) throws InterpolationException {
        Locale defaultLocale;
        String messagePattern = this.getPattern(locale, key);
        if (messagePattern == null && !(defaultLocale = Locale.getDefault()).equals(locale)) {
            messagePattern = this.getPattern(defaultLocale, key);
        }
        if (messagePattern != null) {
            return MessageFormat.format(messagePattern, args);
        }
        throw new InterpolationException().initMessageKey(key.toString());
    }
}

