/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.security;

import java.io.Serializable;
import java.security.Principal;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.webapp.security.UserSession;

@Startup
@Name(value="userSession")
@Scope(value=ScopeType.SESSION)
public class UserSessionBean
implements Serializable,
UserSession {
    private static final long serialVersionUID = 7639281445209754L;
    private Principal currentUser;
    private static final Log log = LogFactory.getLog(UserSessionBean.class);

    @Override
    @Factory(value="currentUser", scope=ScopeType.SESSION)
    public Principal getCurrentUser() {
        if (this.currentUser == null) {
            FacesContext fContext = FacesContext.getCurrentInstance();
            if (fContext == null) {
                this.currentUser = null;
                log.error((Object)"Can not fetch user principal from FacesContext: there is no FacesContext attached to the current request");
            } else {
                this.currentUser = fContext.getExternalContext().getUserPrincipal();
            }
        }
        return this.currentUser;
    }

    @Override
    @Factory(value="currentNuxeoPrincipal", scope=ScopeType.SESSION)
    public NuxeoPrincipal getCurrentNuxeoPrincipal() {
        return (NuxeoPrincipal)this.getCurrentUser();
    }

    @Override
    public boolean isAdministrator() {
        NuxeoPrincipal user = this.getCurrentNuxeoPrincipal();
        if (user == null) {
            return false;
        }
        return user.isAdministrator();
    }

    @Override
    @Destroy
    public void destroy() {
    }
}

