/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.bulkedit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.webapp.bulkedit.BulkEditService;
import org.nuxeo.ecm.webapp.bulkedit.VersioningDescriptor;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class BulkEditServiceImpl
extends DefaultComponent
implements BulkEditService {
    public static final String VERSIONING_EP = "versioning";
    public static final VersioningOption DEFAULT_VERSIONING_OPTION = VersioningOption.MINOR;
    private static final Log log = LogFactory.getLog(BulkEditServiceImpl.class);
    protected VersioningOption defaultVersioningOption = DEFAULT_VERSIONING_OPTION;

    @Override
    public void updateDocuments(CoreSession session, DocumentModel sourceDoc, List<DocumentModel> targetDocs) {
        List<String> propertiesToCopy = this.getPropertiesToCopy(sourceDoc);
        if (propertiesToCopy.isEmpty()) {
            return;
        }
        for (DocumentModel targetDoc : targetDocs) {
            for (String propertyToCopy : propertiesToCopy) {
                try {
                    targetDoc.setPropertyValue(propertyToCopy, sourceDoc.getPropertyValue(propertyToCopy));
                }
                catch (PropertyNotFoundException e) {
                    String message = "%s property does not exist on %s";
                    log.warn((Object)String.format(message, propertyToCopy, targetDoc));
                }
            }
            targetDoc.putContextData("VersioningOption", (Serializable)this.defaultVersioningOption);
            session.saveDocument(targetDoc);
        }
    }

    protected List<String> getPropertiesToCopy(DocumentModel sourceDoc) {
        ArrayList<String> propertiesToCopy = new ArrayList<String>();
        for (Map.Entry entry : sourceDoc.getContextData().entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("bulkEdit/")) continue;
            String[] properties = key.replace("bulkEdit/", "").split(" ");
            Serializable value = (Serializable)entry.getValue();
            if (!(value instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
            for (String property : properties) {
                if (property.startsWith("contextData")) continue;
                propertiesToCopy.add(property);
            }
        }
        return propertiesToCopy;
    }

    @Deprecated
    protected void checkIn(DocumentModel doc) {
        if (this.defaultVersioningOption != null && this.defaultVersioningOption != VersioningOption.NONE && doc.isCheckedOut()) {
            doc.checkIn(this.defaultVersioningOption, null);
        }
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        VersioningDescriptor desc;
        String defaultVer;
        if (VERSIONING_EP.equals(extensionPoint) && !StringUtils.isBlank((String)(defaultVer = (desc = (VersioningDescriptor)contribution).getDefaultVersioningOption()))) {
            try {
                this.defaultVersioningOption = VersioningOption.valueOf((String)defaultVer.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                log.warn((Object)String.format("Illegal versioning option: %s, using %s instead", defaultVer, DEFAULT_VERSIONING_OPTION));
                this.defaultVersioningOption = DEFAULT_VERSIONING_OPTION;
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (VERSIONING_EP.equals(extensionPoint)) {
            this.defaultVersioningOption = DEFAULT_VERSIONING_OPTION;
        }
    }
}

