/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting.wrapper;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jboss.seam.remoting.wrapper.BagWrapper;
import org.jboss.seam.remoting.wrapper.BeanWrapper;
import org.jboss.seam.remoting.wrapper.BooleanWrapper;
import org.jboss.seam.remoting.wrapper.DateWrapper;
import org.jboss.seam.remoting.wrapper.MapWrapper;
import org.jboss.seam.remoting.wrapper.NullWrapper;
import org.jboss.seam.remoting.wrapper.NumberWrapper;
import org.jboss.seam.remoting.wrapper.StringWrapper;
import org.jboss.seam.remoting.wrapper.Wrapper;

public class WrapperFactory {
    private static final WrapperFactory factory = new WrapperFactory();
    private Map<String, Class> wrapperRegistry = new HashMap<String, Class>();
    private Map<Class, Class> classRegistry = new HashMap<Class, Class>();

    private WrapperFactory() {
        this.registerWrapper("str", StringWrapper.class);
        this.registerWrapper("bool", BooleanWrapper.class);
        this.registerWrapper("bean", BeanWrapper.class);
        this.registerWrapper("number", NumberWrapper.class);
        this.registerWrapper("null", NullWrapper.class);
        this.registerWrapper("bag", BagWrapper.class);
        this.registerWrapper("map", MapWrapper.class);
        this.registerWrapper("date", DateWrapper.class);
        this.registerWrapperClass(String.class, StringWrapper.class);
        this.registerWrapperClass(StringBuilder.class, StringWrapper.class);
        this.registerWrapperClass(StringBuffer.class, StringWrapper.class);
        this.registerWrapperClass(Character.class, StringWrapper.class);
        this.registerWrapperClass(BigDecimal.class, StringWrapper.class);
        this.registerWrapperClass(BigInteger.class, StringWrapper.class);
        this.registerWrapperClass(Integer.class, NumberWrapper.class);
        this.registerWrapperClass(Long.class, NumberWrapper.class);
        this.registerWrapperClass(Short.class, NumberWrapper.class);
        this.registerWrapperClass(Double.class, NumberWrapper.class);
        this.registerWrapperClass(Float.class, NumberWrapper.class);
        this.registerWrapperClass(Byte.class, NumberWrapper.class);
    }

    public void registerWrapper(String type, Class wrapperClass) {
        this.wrapperRegistry.put(type, wrapperClass);
    }

    public void registerWrapperClass(Class cls, Class wrapperClass) {
        this.classRegistry.put(cls, wrapperClass);
    }

    public static WrapperFactory getInstance() {
        return factory;
    }

    public Wrapper createWrapper(String type) {
        Class wrapperClass = this.wrapperRegistry.get(type);
        if (wrapperClass != null) {
            try {
                Wrapper wrapper = (Wrapper)wrapperClass.newInstance();
                return wrapper;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new RuntimeException(String.format("Failed to create wrapper for type: %s", type));
    }

    public Wrapper getWrapperForObject(Object obj) {
        if (obj == null) {
            return new NullWrapper();
        }
        Wrapper w = null;
        if (Map.class.isAssignableFrom(obj.getClass())) {
            w = new MapWrapper();
        } else if (obj.getClass().isArray() || Collection.class.isAssignableFrom(obj.getClass())) {
            w = new BagWrapper();
        } else if (obj.getClass().equals(Boolean.class) || obj.getClass().equals(Boolean.TYPE)) {
            w = new BooleanWrapper();
        } else if (obj.getClass().isEnum()) {
            w = new StringWrapper();
        } else if (Date.class.isAssignableFrom(obj.getClass()) || Calendar.class.isAssignableFrom(obj.getClass())) {
            w = new DateWrapper();
        } else if (this.classRegistry.containsKey(obj.getClass())) {
            try {
                w = (Wrapper)this.classRegistry.get(obj.getClass()).newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to create wrapper instance.");
            }
        } else {
            w = new BeanWrapper();
        }
        w.setValue(obj);
        return w;
    }
}

