/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.jsf.actions;

import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.Messages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.collections.api.FavoritesManager;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.runtime.api.Framework;

@Name(value="favoritesActions")
@Scope(value=ScopeType.STATELESS)
@BypassInterceptors
public class FavoritesActionBean {
    public void addCurrentDocumentToFavorites() {
        CoreSession session;
        FavoritesManager favoritesManager;
        NavigationContext navigationContext = (NavigationContext)Component.getInstance((String)"navigationContext", (boolean)true);
        DocumentModel currentDocument = navigationContext.getCurrentDocument();
        if (currentDocument != null && !(favoritesManager = (FavoritesManager)Framework.getLocalService(FavoritesManager.class)).isFavorite(currentDocument, session = (CoreSession)Component.getInstance((String)"documentManager", (boolean)true))) {
            favoritesManager.addToFavorites(currentDocument, session);
            navigationContext.invalidateCurrentDocument();
            Events.instance().raiseEvent("documentChanged", new Object[0]);
            FacesMessages facesMessages = (FacesMessages)Component.getInstance((String)"facesMessages", (boolean)true);
            facesMessages.add(StatusMessage.Severity.INFO, (String)Messages.instance().get("favorites.addedToFavorites"), new Object[0]);
        }
    }

    public boolean canCurrentDocumentBeAddedToFavorites() {
        NavigationContext navigationContext = (NavigationContext)Component.getInstance((String)"navigationContext", (boolean)true);
        DocumentModel currentDocument = navigationContext.getCurrentDocument();
        if (currentDocument != null) {
            FavoritesManager favoritesManager = (FavoritesManager)Framework.getLocalService(FavoritesManager.class);
            CollectionManager collectionManager = (CollectionManager)Framework.getLocalService(CollectionManager.class);
            CoreSession session = (CoreSession)Component.getInstance((String)"documentManager", (boolean)true);
            return collectionManager.isCollectable(currentDocument) && !favoritesManager.isFavorite(currentDocument, session);
        }
        return false;
    }

    public boolean canCurrentDocumentBeRemovedFromFavorites() {
        NavigationContext navigationContext = (NavigationContext)Component.getInstance((String)"navigationContext", (boolean)true);
        DocumentModel currentDocument = navigationContext.getCurrentDocument();
        if (currentDocument != null) {
            FavoritesManager favoritesManager = (FavoritesManager)Framework.getLocalService(FavoritesManager.class);
            CoreSession session = (CoreSession)Component.getInstance((String)"documentManager", (boolean)true);
            return favoritesManager.isFavorite(currentDocument, session);
        }
        return false;
    }

    @Factory(value="currentUserFavorites", scope=ScopeType.SESSION)
    public DocumentModel getCurrentFavorites() {
        FavoritesManager favoritesManager = (FavoritesManager)Framework.getLocalService(FavoritesManager.class);
        NavigationContext navigationContext = (NavigationContext)Component.getInstance((String)"navigationContext", (boolean)true);
        CoreSession session = (CoreSession)Component.getInstance((String)"documentManager", (boolean)true);
        return favoritesManager.getFavorites(navigationContext.getCurrentDomain(), session);
    }

    public void removeCurrentDocumentFromFavorites() {
        CoreSession session;
        FavoritesManager favoritesManager;
        NavigationContext navigationContext = (NavigationContext)Component.getInstance((String)"navigationContext", (boolean)true);
        DocumentModel currentDocument = navigationContext.getCurrentDocument();
        if (currentDocument != null && (favoritesManager = (FavoritesManager)Framework.getLocalService(FavoritesManager.class)).isFavorite(currentDocument, session = (CoreSession)Component.getInstance((String)"documentManager", (boolean)true))) {
            favoritesManager.removeFromFavorites(currentDocument, session);
            navigationContext.invalidateCurrentDocument();
            Events.instance().raiseEvent("documentChanged", new Object[0]);
            FacesMessages facesMessages = (FacesMessages)Component.getInstance((String)"facesMessages", (boolean)true);
            facesMessages.add(StatusMessage.Severity.INFO, (String)Messages.instance().get("favorites.removedFromFavorites"), new Object[0]);
        }
    }
}

