/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.UserEntry;
import org.nuxeo.ecm.core.api.security.impl.UserEntryImpl;
import org.nuxeo.ecm.webapp.security.SecurityData;

public class SecurityDataConverter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SecurityDataConverter.class);

    public static void convertToSecurityData(ACP acp, SecurityData securityData) {
        if (null == acp || null == securityData) {
            log.error((Object)"Null params received, returning...");
            return;
        }
        securityData.clear();
        block0: for (ACL acl : acp.getACLs()) {
            boolean modifiable = acl.getName().equals("local");
            for (ACE entry : acl.getACEs()) {
                if (modifiable) {
                    securityData.addModifiablePrivilege(entry.getUsername(), entry.getPermission(), entry.isGranted());
                } else {
                    securityData.addUnModifiablePrivilege(entry.getUsername(), entry.getPermission(), entry.isGranted());
                }
                if (!entry.isGranted() && entry.getUsername().equals("Everyone") && entry.getPermission().equals("Everything")) continue block0;
            }
        }
        securityData.rebuildUserLists();
        securityData.setNeedSave(false);
    }

    public static List<UserEntry> convertToUserEntries(SecurityData securityData) {
        UserEntryImpl entry;
        if (securityData == null) {
            log.error((Object)"Null params received, returning...");
            return Collections.emptyList();
        }
        Map<String, List<String>> grants = securityData.getCurrentDocGrant();
        Map<String, List<String>> denies = securityData.getCurrentDocDeny();
        ArrayList<UserEntry> entries = new ArrayList<UserEntry>(grants.size() + denies.size());
        for (Map.Entry<String, List<String>> e : grants.entrySet()) {
            entry = new UserEntryImpl(e.getKey());
            for (String permission : e.getValue()) {
                entry.addPrivilege(permission, true, false);
            }
            entries.add((UserEntry)entry);
        }
        for (Map.Entry<String, List<String>> e : denies.entrySet()) {
            entry = new UserEntryImpl(e.getKey());
            for (String permission : e.getValue()) {
                entry.addPrivilege(permission, false, false);
            }
            entries.add((UserEntry)entry);
        }
        return entries;
    }
}

