/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.action;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.convert.api.ConverterCheckResult;
import org.nuxeo.ecm.core.convert.api.ConverterNotRegistered;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.cache.ThreadSafeCacheHolder;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.webapp.action.ConversionAction;
import org.nuxeo.runtime.api.Framework;

@Name(value="conversionActions")
@Scope(value=ScopeType.EVENT)
public class ConversionActionBean
implements ConversionAction {
    private static final Log log = LogFactory.getLog(ConversionActionBean.class);
    protected Map<String, ConverterCheckResult> pdfConverterForTypes;
    @In(create=true, required=false)
    CoreSession documentManager;
    @In(create=true)
    NavigationContext navigationContext;
    @RequestParameter
    private String docRef;
    @RequestParameter
    private String fileFieldFullName;
    @RequestParameter
    private String filename;
    protected String pdfConverterName;
    protected static final ThreadSafeCacheHolder<Boolean> exportableToPDFCache = new ThreadSafeCacheHolder(20);

    public String display() {
        return "view_file";
    }

    private DocumentModel getDocument() {
        if (this.docRef == null) {
            return this.navigationContext.getCurrentDocument();
        }
        return this.documentManager.getDocument((DocumentRef)new IdRef(this.docRef));
    }

    private String getMimetypeFromDocument(String propertyName) {
        Blob blob = (Blob)this.getDocument().getPropertyValue(propertyName);
        return blob.getMimeType();
    }

    @Override
    public void reCheckConverterAvailability() {
        this.pdfConverterForTypes.clear();
    }

    public boolean isExportableToPDF(BlobHolder bh) {
        if (bh == null) {
            return false;
        }
        Blob blob = bh.getBlob();
        return blob != null && this.isExportableToPDF(blob);
    }

    @Override
    public boolean isExportableToPDF(Blob blob) {
        if (blob == null) {
            return false;
        }
        if (this.getPDFConversionURL(blob) != null) {
            return true;
        }
        String mimeType = blob.getMimeType();
        return this.isMimeTypeExportableToPDF(mimeType);
    }

    protected String getPDFConversionURL(Blob blob) {
        BlobManager blobManager = (BlobManager)Framework.getService(BlobManager.class);
        try {
            URI uri = (URI)blobManager.getAvailableConversions(blob, BlobManager.UsageHint.DOWNLOAD).get("application/pdf");
            if (uri != null) {
                return uri.toString();
            }
        }
        catch (IOException e) {
            log.error((Object)"Failed to retrieve available conversions", (Throwable)e);
        }
        return null;
    }

    protected boolean isMimeTypeExportableToPDF(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        if (this.pdfConverterForTypes == null) {
            this.pdfConverterForTypes = new HashMap<String, ConverterCheckResult>();
        }
        if (this.pdfConverterForTypes.containsKey(mimeType)) {
            return this.pdfConverterForTypes.get(mimeType).isAvailable();
        }
        try {
            ConversionService conversionService = (ConversionService)Framework.getLocalService(ConversionService.class);
            for (String this.pdfConverterName : conversionService.getConverterNames(mimeType, "application/pdf")) {
                ConverterCheckResult pdfConverterAvailability = conversionService.isConverterAvailable(this.pdfConverterName, true);
                for (String supMimeType : pdfConverterAvailability.getSupportedInputMimeTypes()) {
                    this.pdfConverterForTypes.put(supMimeType, pdfConverterAvailability);
                }
                if (!pdfConverterAvailability.isAvailable()) continue;
                return true;
            }
        }
        catch (ConverterNotRegistered e) {
            log.error((Object)"Error while testing PDF converter availability", (Throwable)e);
        }
        return false;
    }

    @Override
    @WebRemote
    public boolean isFileExportableToPDF(String fieldName) {
        boolean isSupported;
        DocumentModel doc = this.getDocument();
        Boolean cacheResult = (Boolean)exportableToPDFCache.getFromCache(doc, fieldName);
        if (cacheResult == null) {
            String mimetype = this.getMimetypeFromDocument(fieldName);
            isSupported = this.isMimeTypeExportableToPDF(mimetype);
            exportableToPDFCache.addToCache(doc, fieldName, (Serializable)Boolean.valueOf(isSupported));
        } else {
            isSupported = cacheResult;
        }
        return isSupported;
    }

    public String generatePdfFileFromBlobHolder(DocumentModel doc, BlobHolder bh) throws IOException {
        Blob blob = bh.getBlob();
        String url = this.getPDFConversionURL(blob);
        if (url != null) {
            try {
                FacesContext.getCurrentInstance().getExternalContext().redirect(url);
                return null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.pdfConverterName == null) {
            log.error((Object)"No PDF converter was found.");
            return "pdf_generation_error";
        }
        Blob result = ((ConversionService)Framework.getService(ConversionService.class)).convertToMimeType("application/pdf", bh, Collections.emptyMap()).getBlob();
        if (result == null) {
            log.error((Object)"Transform service didn't return any resulting documents which is not normal.");
            return "pdf_generation_error";
        }
        String xpath = bh instanceof DocumentBlobHolder ? ((DocumentBlobHolder)bh).getXpath() : null;
        ComponentUtils.download((DocumentModel)doc, (String)xpath, (Blob)result, (String)result.getFilename(), (String)"pdfConversion");
        return null;
    }

    @Override
    @WebRemote
    public String generatePdfFile() throws IOException {
        DocumentModel doc = this.getDocument();
        DocumentBlobHolder bh = new DocumentBlobHolder(doc, this.fileFieldFullName);
        return this.generatePdfFileFromBlobHolder(doc, (BlobHolder)bh);
    }

    public boolean isPDF(BlobHolder bh) {
        if (bh == null) {
            return false;
        }
        Blob blob = bh.getBlob();
        return blob != null && this.isPDF(blob);
    }

    public boolean isPDF(Blob blob) {
        if (blob == null) {
            return false;
        }
        String mimeType = blob.getMimeType();
        if (StringUtils.isNotBlank((String)mimeType) && "application/pdf".equals(mimeType)) {
            return true;
        }
        String filename = blob.getFilename();
        return StringUtils.isNotBlank((String)filename) && filename.endsWith(".pdf");
    }

    public void initialize() {
    }
}

