/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.directory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.core.Events;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.contentview.seam.ContentViewActions;
import org.nuxeo.ecm.platform.ui.web.directory.DirectoryHelper;
import org.nuxeo.ecm.platform.ui.web.util.SeamContextHelper;
import org.nuxeo.ecm.webapp.directory.DirectoryTreeDescriptor;
import org.nuxeo.ecm.webapp.tree.TreeActionsBean;
import org.nuxeo.runtime.api.Framework;

public class DirectoryTreeNode {
    private static final Log log = LogFactory.getLog(DirectoryTreeNode.class);
    public static final String PARENT_FIELD_ID = "parent";
    private static final String LABEL_FIELD_ID = "label";
    protected final String path;
    protected final int level;
    protected Boolean open = null;
    protected final DirectoryTreeDescriptor config;
    protected String identifier;
    protected String description;
    protected boolean leaf = false;
    protected String type = "defaultDirectoryTreeNode";
    protected DirectoryService directoryService;
    protected ContentView contentView;
    protected DocumentModelList childrenEntries;
    protected List<DirectoryTreeNode> children;

    public DirectoryTreeNode(int level, DirectoryTreeDescriptor config, String identifier, String description, String path, DirectoryService directoryService) {
        this.level = level;
        this.config = config;
        this.identifier = identifier;
        this.description = description;
        this.path = path;
        this.directoryService = directoryService;
    }

    protected List<String> processSelectedValuesOnMultiSelect(String value, List<String> values) {
        if (values.contains(value)) {
            values.remove(value);
        } else {
            ArrayList<String> valuesToRemove = new ArrayList<String>();
            String valueSlash = value + "/";
            for (String existingSelection : values) {
                String existingSelectionSlash = existingSelection + "/";
                if (!existingSelectionSlash.startsWith(valueSlash) && !valueSlash.startsWith(existingSelectionSlash)) continue;
                valuesToRemove.add(existingSelection);
            }
            values.removeAll(valuesToRemove);
            values.add(value);
        }
        return values;
    }

    public String selectNode() {
        if (this.config.hasContentViewSupport()) {
            DocumentModel searchDoc = this.getContentViewSearchDocumentModel();
            if (searchDoc != null) {
                String fieldName = this.config.getFieldName();
                String schemaName = this.config.getSchemaName();
                if (this.config.isMultiselect()) {
                    List<String> values = (List<String>)searchDoc.getProperty(schemaName, fieldName);
                    values = this.processSelectedValuesOnMultiSelect(this.path, values);
                    searchDoc.setProperty(schemaName, fieldName, values);
                } else {
                    searchDoc.setProperty(schemaName, fieldName, (Object)this.path);
                }
                if (this.contentView != null) {
                    this.contentView.refreshPageProvider();
                }
            } else {
                log.error((Object)"Cannot select node: search document model is null");
            }
        } else {
            log.error((Object)String.format("Cannot select node on tree '%s': no content view available", this.identifier));
        }
        Events.instance().raiseEvent("folderishDocumentSelectionChanged", new Object[]{new DocumentModelImpl("Folder")});
        this.pathProcessing();
        return this.config.getOutcome();
    }

    public boolean isSelected() {
        if (this.config.hasContentViewSupport()) {
            DocumentModel searchDoc = this.getContentViewSearchDocumentModel();
            if (searchDoc != null) {
                String fieldName = this.config.getFieldName();
                String schemaName = this.config.getSchemaName();
                if (this.config.isMultiselect()) {
                    List values = (List)searchDoc.getProperty(schemaName, fieldName);
                    return values.contains(this.path);
                }
                return this.path.equals(searchDoc.getProperty(schemaName, fieldName));
            }
            log.error((Object)"Cannot check if node is selected: search document model is null");
        } else {
            log.error((Object)String.format("Cannot check if node is selected on tree '%s': no content view available", this.identifier));
        }
        return false;
    }

    public int getChildCount() {
        if (this.isLastLevel()) {
            return 0;
        }
        return this.getChildrenEntries().size();
    }

    public List<DirectoryTreeNode> getChildren() {
        if (this.children != null) {
            return this.children;
        }
        this.children = new ArrayList<DirectoryTreeNode>();
        if (this.isLastLevel()) {
            return this.children;
        }
        String schema = this.getDirectorySchema();
        DocumentModelList results = this.getChildrenEntries();
        FacesContext context = FacesContext.getCurrentInstance();
        for (DocumentModel result : results) {
            String childIdendifier = result.getId();
            String childDescription = DirectoryTreeNode.translate(context, (String)result.getProperty(schema, LABEL_FIELD_ID));
            String childPath = "".equals(this.path) ? childIdendifier : this.path + '/' + childIdendifier;
            this.children.add(new DirectoryTreeNode(this.level + 1, this.config, childIdendifier, childDescription, childPath, this.getDirectoryService()));
        }
        FieldComparator cmp = new FieldComparator();
        Collections.sort(this.children, cmp);
        return this.children;
    }

    protected static String translate(FacesContext context, String label) {
        String bundleName = context.getApplication().getMessageBundle();
        Locale locale = context.getViewRoot().getLocale();
        label = I18NUtils.getMessageString((String)bundleName, (String)label, null, (Locale)locale);
        return label;
    }

    protected DocumentModelList getChildrenEntries() {
        if (this.childrenEntries != null) {
            return this.childrenEntries;
        }
        try (Session session = this.getDirectorySession();){
            if (this.level == 0) {
                String schemaName = this.getDirectorySchema();
                SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
                Schema schema = schemaManager.getSchema(schemaName);
                if (schema.hasField(PARENT_FIELD_ID)) {
                    HashMap<String, String> filter = new HashMap<String, String>();
                    filter.put(PARENT_FIELD_ID, "");
                    this.childrenEntries = session.query(filter);
                } else {
                    this.childrenEntries = session.getEntries();
                }
            } else {
                HashMap<String, String> filter = new HashMap<String, String>();
                String[] bitsOfPath = this.path.split("/");
                filter.put(PARENT_FIELD_ID, bitsOfPath[this.level - 1]);
                this.childrenEntries = session.query(filter);
            }
            DocumentModelList documentModelList = this.childrenEntries;
            return documentModelList;
        }
    }

    public String getDescription() {
        if (this.level == 0) {
            return DirectoryTreeNode.translate(FacesContext.getCurrentInstance(), this.description);
        }
        return this.description;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getPath() {
        return this.path;
    }

    public String getType() {
        return this.type;
    }

    public boolean isLeaf() {
        return this.leaf || this.isLastLevel() || this.getChildCount() == 0;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setLeaf(boolean leaf) {
        this.leaf = leaf;
    }

    public void setType(String type) {
        this.type = type;
    }

    protected DirectoryService getDirectoryService() {
        if (this.directoryService == null) {
            this.directoryService = DirectoryHelper.getDirectoryService();
        }
        return this.directoryService;
    }

    protected String getDirectoryName() {
        String name = this.config.getDirectories()[this.level];
        if (name == null) {
            throw new NuxeoException("could not find directory name for level=" + this.level);
        }
        return name;
    }

    protected String getDirectorySchema() {
        return this.getDirectoryService().getDirectorySchema(this.getDirectoryName());
    }

    protected Session getDirectorySession() {
        return this.getDirectoryService().open(this.getDirectoryName());
    }

    protected void lookupContentView() {
        if (this.contentView != null) {
            return;
        }
        SeamContextHelper seamContextHelper = new SeamContextHelper();
        ContentViewActions cva = (ContentViewActions)seamContextHelper.get("contentViewActions");
        this.contentView = cva.getContentView(this.config.getContentView());
        if (this.contentView == null) {
            throw new NuxeoException("no content view registered as " + this.config.getContentView());
        }
    }

    protected DocumentModel getContentViewSearchDocumentModel() {
        this.lookupContentView();
        if (this.contentView != null) {
            return this.contentView.getSearchDocumentModel();
        }
        return null;
    }

    protected boolean isLastLevel() {
        return this.config.getDirectories().length == this.level;
    }

    public void pathProcessing() throws DirectoryException {
        if (this.config.isMultiselect()) {
            return;
        }
        String aPath = null;
        if (this.config.hasContentViewSupport()) {
            DocumentModel searchDoc = this.getContentViewSearchDocumentModel();
            if (searchDoc != null) {
                aPath = (String)searchDoc.getProperty(this.config.getSchemaName(), this.config.getFieldName());
            } else {
                log.error((Object)"Cannot perform path preprocessing: search document model is null");
            }
        }
        if (aPath != null && aPath != "") {
            String[] bitsOfPath = aPath.split("/");
            String myPath = "";
            String property = "";
            for (int b = 0; b < bitsOfPath.length; ++b) {
                String dirName = this.config.getDirectories()[b];
                if (dirName == null) {
                    throw new DirectoryException("Could not find directory name for key=" + b);
                }
                try (Session session = this.getDirectoryService().open(dirName);){
                    DocumentModel docMod = session.getEntry(bitsOfPath[b]);
                    try {
                        String schemaName = docMod.getSchemas()[0];
                        property = (String)docMod.getProperty(schemaName, LABEL_FIELD_ID);
                    }
                    catch (PropertyException e) {
                        throw new DirectoryException((Throwable)e);
                    }
                    myPath = myPath + property + '/';
                    continue;
                }
            }
            Events.instance().raiseEvent("PATH_PROCESSED", new Object[]{myPath});
        } else {
            Events.instance().raiseEvent("PATH_PROCESSED", new Object[]{""});
        }
    }

    @Deprecated
    public boolean isOpened() {
        return this.isOpen();
    }

    public boolean isOpen() {
        TreeActionsBean treeActionBean;
        if (this.open == null && !(treeActionBean = (TreeActionsBean)Component.getInstance((String)"treeActions")).isNodeExpandEvent()) {
            if (!this.config.isMultiselect() && this.config.hasContentViewSupport()) {
                DocumentModel searchDoc = this.getContentViewSearchDocumentModel();
                if (searchDoc != null) {
                    String fieldName = this.config.getFieldName();
                    String schemaName = this.config.getSchemaName();
                    Object value = searchDoc.getProperty(schemaName, fieldName);
                    if (value instanceof String) {
                        this.open = ((String)value).startsWith(this.path);
                    }
                } else {
                    log.error((Object)"Cannot check if node is opened: search document model is null");
                }
            } else {
                log.error((Object)String.format("Cannot check if node is opened on tree '%s': no content view available", this.identifier));
            }
        }
        return Boolean.TRUE.equals(this.open);
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    private class FieldComparator
    implements Comparator<DirectoryTreeNode> {
        private FieldComparator() {
        }

        @Override
        public int compare(DirectoryTreeNode o1, DirectoryTreeNode o2) {
            return ObjectUtils.compare((Comparable)((Object)o1.getDescription()), (Comparable)((Object)o2.getDescription()));
        }
    }
}

