/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.application;

import com.noelios.restlet.application.ApplicationContext;
import java.util.logging.Logger;
import org.restlet.Uniform;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Response;

public class ApplicationDispatcher
extends Uniform {
    private ApplicationContext applicationContext;

    public ApplicationDispatcher(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void handle(Request request, Response response) {
        Protocol protocol = request.getProtocol();
        if (protocol == null) {
            throw new UnsupportedOperationException("Unable to determine the protocol to use for this call.");
        }
        request.getAttributes().put("org.restlet.application", this.applicationContext.getApplication());
        response.getAttributes().put("org.restlet.application", this.applicationContext.getApplication());
        if (protocol.equals((Object)Protocol.WAR)) {
            this.applicationContext.getWarClient().handle(request, response);
        } else {
            if (!this.applicationContext.getApplication().getConnectorService().getClientProtocols().contains(protocol)) {
                this.applicationContext.getLogger().fine("The protocol used by this request is not declared in the application's connector service. Please update the list of client connectors used by your application and restart it.");
            }
            if (this.applicationContext != null) {
                if (this.applicationContext.getParentContext() != null) {
                    this.applicationContext.getParentContext().getDispatcher().handle(request, response);
                } else {
                    Logger.getLogger(ApplicationDispatcher.class.getCanonicalName()).warning("Your Application doesn't have a parent context available. Ensure that the parent Component has a context set.");
                }
            } else {
                Logger.getLogger(ApplicationDispatcher.class.getCanonicalName()).warning("Your Application doesn't have a context set. Ensure that you pass the parent Component's context to your Application constructor.");
            }
        }
    }
}

