/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import org.richfaces.component.UIDataAdaptor;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

public class RowKeyContextEventWrapper
extends FacesEvent {
    private static final long serialVersionUID = -869970815228914529L;
    private static final Logger LOGGER = RichfacesLogger.COMPONENTS.getLogger();
    private FacesEvent event;
    private Object eventRowKey;
    private Object initialRowKey;

    public RowKeyContextEventWrapper(UIDataAdaptor component, FacesEvent event, Object eventRowKey) {
        super((UIComponent)component);
        this.event = event;
        this.eventRowKey = eventRowKey;
    }

    public FacesEvent getFacesEvent() {
        return this.event;
    }

    public PhaseId getPhaseId() {
        return this.event.getPhaseId();
    }

    public void setPhaseId(PhaseId phaseId) {
        this.event.setPhaseId(phaseId);
    }

    public boolean isAppropriateListener(FacesListener listener) {
        return false;
    }

    public void processListener(FacesListener listener) {
        throw new IllegalStateException();
    }

    public UIDataAdaptor getComponent() {
        return (UIDataAdaptor)super.getComponent();
    }

    public Object getEventRowKey() {
        return this.eventRowKey;
    }

    protected void setupEventContext(FacesContext facesContext) {
        this.getComponent().setRowKey(facesContext, this.getEventRowKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(FacesContext context) throws AbortProcessingException {
        UIDataAdaptor dataAdaptor = this.getComponent();
        this.initialRowKey = dataAdaptor.getRowKey();
        UIComponent compositeParent = null;
        UIComponent targetComponent = this.event.getComponent();
        try {
            if (!UIComponent.isCompositeComponent((UIComponent)targetComponent)) {
                compositeParent = UIComponent.getCompositeComponentParent((UIComponent)targetComponent);
            }
            if (compositeParent != null) {
                compositeParent.pushComponentToEL(context, null);
            }
            this.setupEventContext(context);
            targetComponent.pushComponentToEL(context, null);
            targetComponent.broadcast(this.event);
        }
        finally {
            try {
                dataAdaptor.setRowKey(context, this.initialRowKey);
            }
            catch (Exception e) {
                LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
            }
            this.initialRowKey = null;
            targetComponent.popComponentFromEL(context);
            if (compositeParent != null) {
                compositeParent.popComponentFromEL(context);
            }
        }
    }
}

