/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.mapping.backward.impl;

import javax.xml.bind.JAXBElement;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import yarfraw.core.datamodel.ChannelFeed;
import yarfraw.core.datamodel.Generator;
import yarfraw.core.datamodel.Image;
import yarfraw.generated.atom10.elements.CategoryType;
import yarfraw.generated.atom10.elements.DateTimeType;
import yarfraw.generated.atom10.elements.EntryType;
import yarfraw.generated.atom10.elements.FeedType;
import yarfraw.generated.atom10.elements.GeneratorType;
import yarfraw.generated.atom10.elements.IconType;
import yarfraw.generated.atom10.elements.IdType;
import yarfraw.generated.atom10.elements.LinkType;
import yarfraw.generated.atom10.elements.LogoType;
import yarfraw.generated.atom10.elements.PersonType;
import yarfraw.generated.atom10.elements.TextType;
import yarfraw.io.parser.ElementQName;
import yarfraw.mapping.backward.ToChannelAtom10;
import yarfraw.mapping.backward.impl.Atom10MappingUtils;
import yarfraw.utils.XMLUtils;

public class ToChannelAtom10Impl
implements ToChannelAtom10 {
    private static final Log LOG = LogFactory.getLog(ToChannelAtom10Impl.class);
    private static final ToChannelAtom10 _instance = new ToChannelAtom10Impl();

    private ToChannelAtom10Impl() {
    }

    public static ToChannelAtom10 getInstance() {
        return _instance;
    }

    public ChannelFeed execute(FeedType feed) {
        if (feed == null) {
            return null;
        }
        ChannelFeed c = new ChannelFeed();
        c.setLang(feed.getLang());
        c.setBase(feed.getBase());
        c.getOtherAttributes().putAll(feed.getOtherAttributes());
        for (Object o : feed.getAuthorOrCategoryOrContributor()) {
            if (o == null) continue;
            if (o instanceof JAXBElement) {
                TextType text;
                JAXBElement jaxbElement = (JAXBElement)o;
                Object val = jaxbElement.getValue();
                if (XMLUtils.same(jaxbElement.getName(), ElementQName.ATOM10_TITLE)) {
                    text = (TextType)val;
                    c.setTitle(Atom10MappingUtils.toText(text));
                    continue;
                }
                if (XMLUtils.same(jaxbElement.getName(), ElementQName.ATOM10_SUBTITLE)) {
                    text = (TextType)val;
                    c.setDescriptionOrSubtitle(Atom10MappingUtils.toText(text));
                    continue;
                }
                if (XMLUtils.same(jaxbElement.getName(), ElementQName.ATOM10_AUTHOR)) {
                    c.addManagingEditorOrAuthorOrPublisher(Atom10MappingUtils.toPersonType((PersonType)val));
                    continue;
                }
                if (XMLUtils.same(jaxbElement.getName(), ElementQName.ATOM10_CONTRIBUTOR)) {
                    c.addContributor(Atom10MappingUtils.toPersonType((PersonType)val));
                    continue;
                }
                if (val instanceof CategoryType) {
                    c.addCategorySubject(Atom10MappingUtils.toCategorySubject((CategoryType)val));
                    continue;
                }
                if (val instanceof GeneratorType) {
                    GeneratorType gen = (GeneratorType)val;
                    c.setGenerator(ToChannelAtom10Impl.toGenerator(gen));
                    continue;
                }
                if (val instanceof IconType) {
                    c.setImageOrIcon(Atom10MappingUtils.toImage((IconType)val));
                    continue;
                }
                if (val instanceof IdType) {
                    c.setUid(Atom10MappingUtils.toId((IdType)val));
                    continue;
                }
                if (val instanceof LinkType) {
                    c.addLink(Atom10MappingUtils.toAtomLink((LinkType)val));
                    continue;
                }
                if (val instanceof LogoType) {
                    LogoType logo = (LogoType)val;
                    c.setLogo(ToChannelAtom10Impl.toLogo(logo));
                    continue;
                }
                if (XMLUtils.same(jaxbElement.getName(), ElementQName.ATOM10_RIGHTS)) {
                    text = (TextType)val;
                    c.setRights(Atom10MappingUtils.toText(text));
                    continue;
                }
                if (XMLUtils.same(jaxbElement.getName(), ElementQName.ATOM10_UPDATED)) {
                    DateTimeType dt = (DateTimeType)val;
                    if (dt.getValue() == null) continue;
                    c.setLastBuildOrUpdatedDate(dt.getValue());
                    continue;
                }
                if (val instanceof EntryType) {
                    c.addItem(Atom10MappingUtils.toItem((EntryType)val));
                    continue;
                }
                LOG.warn((Object)("Unexpected jaxbElement: " + ToStringBuilder.reflectionToString((Object)jaxbElement) + " this should not happen!"));
                continue;
            }
            if (o instanceof Element) {
                Element e = (Element)o;
                c.getOtherElements().add(e);
                continue;
            }
            LOG.warn((Object)("Unexpected object: " + ToStringBuilder.reflectionToString((Object)o) + " this should not happen!"));
        }
        return c;
    }

    private static Generator toGenerator(GeneratorType in) {
        Generator ret = new Generator(in.getValue());
        ret.setUri(in.getUri());
        ret.setVersion(in.getVersion());
        ret.setLang(in.getLang());
        ret.setBase(in.getBase());
        ret.getOtherAttributes().putAll(in.getOtherAttributes());
        return ret;
    }

    public static Image toLogo(LogoType in) {
        Image ret = new Image();
        ret.setUrl(in.getValue());
        ret.setBase(in.getBase());
        ret.setLang(in.getLang());
        if (in.getOtherAttributes() != null) {
            ret.getOtherAttributes().putAll(in.getOtherAttributes());
        }
        return ret;
    }
}

