/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.external;

import java.util.Map;
import javax.faces.context.FacesContext;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.external.ResourceTracker;

public class ResourceTrackerForMojarra
implements ResourceTracker {
    @Override
    public boolean isResourceRenderered(FacesContext facesContext, ResourceKey resourceKey) {
        Map contextMap = facesContext.getAttributes();
        String key = resourceKey.getResourceName() + resourceKey.getLibraryName();
        return contextMap.containsKey(key);
    }

    @Override
    public void markResourceRendered(FacesContext facesContext, ResourceKey resourceKey) {
        Map contextMap = facesContext.getAttributes();
        String resourceName = resourceKey.getResourceName();
        String libraryName = resourceKey.getLibraryName();
        String key = resourceName + libraryName;
        this.putToContext(contextMap, key);
        if (libraryName == null || libraryName.isEmpty()) {
            libraryName = "null";
            key = resourceName + libraryName;
            this.putToContext(contextMap, key);
        }
    }

    private void putToContext(Map<Object, Object> contextMap, String key) {
        if (!contextMap.containsKey(key)) {
            contextMap.put(key, Boolean.TRUE);
        }
    }
}

