/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.regex.Pattern;
import org.ajax4jsf.Messages;

public final class HtmlDimensions {
    private static final Pattern PATTERN_NUMERIC = Pattern.compile("^[+-]?\\d+(\\.\\d+)?$");
    private static final Pattern PATTERN_PX = Pattern.compile("^[+-]?\\d+(\\.\\d+)?px$");
    private static final Pattern PATTERN_PT = Pattern.compile("^[+-]?\\d+(\\.\\d+)?pt$");
    private static final Pattern PATTERN_PCT = Pattern.compile("^[+-]?\\d+(\\.\\d+)?%$");
    private static final NumberFormat NUMERIC_FORMAT = new DecimalFormat();
    private static final DecimalFormat PX_FORMAT = new DecimalFormat();
    private static final DecimalFormat PT_FORMAT = new DecimalFormat();
    private static final NumberFormat PCT_FORMAT = NumberFormat.getPercentInstance();

    private HtmlDimensions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Double decode(String size) {
        double d;
        block17: {
            d = 0.0;
            try {
                if (size == null) break block17;
                if (PATTERN_NUMERIC.matcher(size).matches()) {
                    NumberFormat numberFormat = NUMERIC_FORMAT;
                    synchronized (numberFormat) {
                        d = NUMERIC_FORMAT.parse(size).doubleValue();
                        break block17;
                    }
                }
                if (PATTERN_PX.matcher(size).matches()) {
                    DecimalFormat decimalFormat = PX_FORMAT;
                    synchronized (decimalFormat) {
                        d = PX_FORMAT.parse(size).doubleValue();
                        break block17;
                    }
                }
                if (PATTERN_PT.matcher(size).matches()) {
                    DecimalFormat decimalFormat = PT_FORMAT;
                    synchronized (decimalFormat) {
                        d = PT_FORMAT.parse(size).doubleValue() * 1.3333333333333333;
                        break block17;
                    }
                }
                if (!PATTERN_PCT.matcher(size).matches()) break block17;
                NumberFormat numberFormat = PCT_FORMAT;
                synchronized (numberFormat) {
                    d = PCT_FORMAT.parse(size).doubleValue();
                }
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(Messages.getMessage("DECODE_PARAMETER_ERROR", new Object[]{"size", size, e.getMessage()}));
            }
        }
        return new Double(d);
    }

    public static String formatPx(Double value) {
        return value.intValue() + "px";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatPct(Double value) {
        String v = "";
        NumberFormat numberFormat = PCT_FORMAT;
        synchronized (numberFormat) {
            v = PCT_FORMAT.format(value);
        }
        return v;
    }

    public static String formatSize(String size) {
        char lastChar;
        String incomingSize;
        if (size != null && (incomingSize = size.trim()).length() > 0 && Character.isDigit(lastChar = incomingSize.charAt(incomingSize.length() - 1))) {
            return incomingSize + "px";
        }
        return size;
    }

    static {
        PX_FORMAT.setPositiveSuffix("px");
        PX_FORMAT.setNegativeSuffix("px");
        PT_FORMAT.setPositiveSuffix("pt");
        PT_FORMAT.setNegativeSuffix("pt");
    }
}

